/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.config;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.action.MonitorInterceptor;
import com.af.v4.system.common.jpa.dialect.MyDialectResolver;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.common.jpa.dynamic.DynamicTransactionManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
public class HibernateConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateConfig.class);
    public final String currentSessionContextClass = "org.springframework.orm.hibernate5.SpringSessionContext";
    private final ApplicationContext context;
    private final MonitorInterceptor monitorInterceptor;
    private final ApplicationUtils applicationUtils;

    public HibernateConfig(ApplicationContext context, MonitorInterceptor monitorInterceptor, ApplicationUtils applicationUtils) {
        this.context = context;
        this.monitorInterceptor = monitorInterceptor;
        this.applicationUtils = applicationUtils;
    }

    @Bean
    public DynamicSessionFactory dynamicSessionFactory() {
        Map dataSourceList = DynamicDataSource.getDataSourceList();
        HashMap<Object, LocalSessionFactoryBean> sessionFactoryBeanMap = new HashMap<Object, LocalSessionFactoryBean>(dataSourceList.size());
        dataSourceList.forEach((key, value) -> {
            LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
            sessionFactoryBean.setDataSource((DataSource)value);
            sessionFactoryBean.setPackagesToScan(new String[]{"com.af.v4.entity." + key});
            sessionFactoryBean.setEntityInterceptor((Interceptor)this.monitorInterceptor);
            Properties properties = new Properties();
            EnvType envType = this.applicationUtils.getEnvType();
            if (envType == EnvType.DEV) {
                properties.setProperty("hibernate.hbm2ddl.auto", "update");
            } else {
                properties.setProperty("hibernate.hbm2ddl.auto", "none");
            }
            properties.setProperty("hibernate.show_sql", "false");
            properties.setProperty("hibernate.format_sql", "false");
            properties.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate5.SpringSessionContext");
            if (value.getDialect() != null) {
                properties.setProperty("hibernate.dialect", value.getDialect());
            } else {
                properties.setProperty("hibernate.dialect_resolvers", MyDialectResolver.class.getCanonicalName());
            }
            String driverClassName = value.getDriverClassName();
            boolean isClickhouse = driverClassName.contains("clickhouse");
            if (isClickhouse) {
                properties.setProperty("hibernate.allow_update_outside_transaction", "true");
            }
            sessionFactoryBean.setHibernateProperties(properties);
            List cfgLocations = value.getCfgLocations();
            if (cfgLocations != null && cfgLocations.size() > 0) {
                Resource[] cfgLocationResources = cfgLocations.stream().map(arg_0 -> ((ApplicationContext)this.context).getResource(arg_0)).toList().toArray(new Resource[cfgLocations.size()]);
                sessionFactoryBean.setConfigLocations(cfgLocationResources);
            }
            try {
                sessionFactoryBean.afterPropertiesSet();
            }
            catch (IOException e) {
                LOGGER.error("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
            }
            sessionFactoryBeanMap.put(key, sessionFactoryBean);
        });
        return new DynamicSessionFactoryImpl(sessionFactoryBeanMap, (LocalSessionFactoryBean)sessionFactoryBeanMap.get("master"));
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        transactionManager.setSessionFactory(this.dynamicSessionFactory());
        return transactionManager;
    }
}

