/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.action;

import com.af.v4.system.common.core.exception.CheckedException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.transformer.AliasTransformer;
import com.af.v4.system.common.jpa.transformer.StandardAliasTransformer;
import com.af.v4.system.common.jpa.utils.SQLRuntimeSupport;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Component;

@Component
public class SqlAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlAction.class);
    private final SessionPool sessionPool;

    public SqlAction(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JSONArray queryAll(String name, String sql) {
        return this.query(name, sql, null, null);
    }

    public JSONArray query(String name, String sql) {
        return this.query(name, sql, 0, 1000);
    }

    public JSONArray query(String name, String sql, Integer pageNo, Integer pageSize) {
        return (JSONArray)this.sqlMonitor(() -> {
            boolean userStandardTrans = SQLRuntimeSupport.getStandardTransformerValue();
            AliasedTupleSubsetResultTransformer resultTransformer = userStandardTrans ? StandardAliasTransformer.INSTANCE : AliasTransformer.INSTANCE;
            InnerSQLCall sqlCall = new InnerSQLCall(sql, pageNo, pageSize, (ResultTransformer)resultTransformer);
            JSONArray array = sqlCall.doInHibernate(this.sessionPool.getSession());
            if (array != null) {
                this.writeSqlResult(name, array);
            }
            return array;
        }, name);
    }

    public Integer exec(String name, String sql) {
        return (int)((Integer)this.sqlMonitor(() -> {
            Session session = this.sessionPool.getSession();
            NativeQuery queryObject = session.createNativeQuery(sql);
            return queryObject.executeUpdate();
        }, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sqlMonitor(Process process, String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new CheckedException("\u7f16\u7801\u5f3a\u5236\u6027\u89c4\u8303: \u7f3a\u5c11\u6e05\u6670\u660e\u786e\u7684 SQL \u67e5\u8be2\u6807\u8bc6\u540d\u79f0");
        }
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: \u5f00\u59cb\u6267\u884cSQL[" + name + "]");
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        finally {
            long end = System.currentTimeMillis();
            LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: \u6267\u884cSQL[" + name + "]\u8017\u65f6\uff1a" + (end - begin) + "ms");
        }
    }

    private void writeSqlResult(String name, JSONArray array) {
        Object result = array.toString();
        int length = ((String)result).length();
        if (length > 2000) {
            result = ((String)result).substring(0, 2000) + "...\u540e\u7eed\u8fd8\u6709" + (length - 2000) + "\u4e2a\u5b57\u7b26";
        }
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: SQL[" + name + "]\u67e5\u8be2\u7ed3\u679c: \n" + (String)result);
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    private record InnerSQLCall(String sql, Integer page, Integer rows, ResultTransformer transformer) implements HibernateCallback<JSONArray>
    {
        public JSONArray doInHibernate(Session session) {
            NativeQuery q = session.createNativeQuery(this.sql);
            q.setResultTransformer(this.transformer);
            try {
                List list = this.page == null || this.rows == null ? q.list() : q.setFirstResult(this.page * this.rows).setMaxResults(this.rows.intValue()).list();
                if (this.transformer instanceof StandardAliasTransformer) {
                    return new JSONArray().putAll((Collection)list);
                }
                return new JSONArray((Collection)list);
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

