/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.dialect.MyDialectResolver;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.common.jpa.dynamic.DynamicTransactionManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
public class HibernateConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateConfig.class);
    public final String currentSessionContextClass = "org.springframework.orm.hibernate5.SpringSessionContext";
    private final ApplicationContext context;

    public HibernateConfig(ApplicationContext context) {
        this.context = context;
    }

    @Bean
    public DynamicSessionFactory dynamicSessionFactory() {
        Map dataSourceList = DynamicDataSource.getDataSourceList();
        HashMap<Object, LocalSessionFactoryBean> sessionFactoryBeanMap = new HashMap<Object, LocalSessionFactoryBean>(dataSourceList.size());
        dataSourceList.forEach((key, value) -> {
            LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
            sessionFactoryBean.setDataSource((DataSource)value);
            sessionFactoryBean.setPackagesToScan(new String[]{"com.af.v4.entity." + key});
            Properties properties = new Properties();
            properties.setProperty("hibernate.hbm2ddl.auto", "update");
            properties.setProperty("hibernate.show_sql", "false");
            properties.setProperty("hibernate.format_sql", "false");
            properties.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate5.SpringSessionContext");
            properties.setProperty("hibernate.dialect_resolvers", MyDialectResolver.class.getCanonicalName());
            sessionFactoryBean.setHibernateProperties(properties);
            List cfgLocations = value.getCfgLocations();
            if (cfgLocations != null && cfgLocations.size() > 0) {
                cfgLocations.add("classpath:/querySupport/hibernate.cfg.xml");
                cfgLocations.add("classpath:/liuliSupport/hibernate.cfg.xml");
                Resource[] cfgLocationResources = cfgLocations.stream().map(arg_0 -> ((ApplicationContext)this.context).getResource(arg_0)).toList().toArray(new Resource[cfgLocations.size()]);
                sessionFactoryBean.setConfigLocations(cfgLocationResources);
            }
            try {
                sessionFactoryBean.afterPropertiesSet();
            }
            catch (IOException e) {
                LOGGER.error("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
            }
            sessionFactoryBeanMap.put(key, sessionFactoryBean);
        });
        return new DynamicSessionFactoryImpl(sessionFactoryBeanMap, (LocalSessionFactoryBean)sessionFactoryBeanMap.get("master"));
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        transactionManager.setSessionFactory(this.dynamicSessionFactory());
        return transactionManager;
    }
}

