/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.transformer;

import cn.hutool.core.date.DateUtil;
import com.af.v4.system.common.jpa.utils.ClobUtil;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class StandardAliasTransformer
extends AliasedTupleSubsetResultTransformer {
    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias == null) continue;
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                if (StandardAliasTransformer.isIntegerValue(bigDecimal)) {
                    long longValue = bigDecimal.longValue();
                    value = longValue < Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
                }
            } else if (value instanceof Date) {
                Date date = (Date)value;
                value = DateUtil.formatDateTime((Date)date);
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                value = ClobUtil.getClobString(clob);
            }
            if (obj instanceof JSONObject) {
                JSONObject object = (JSONObject)obj;
                object.put(alias.toLowerCase(), value);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map objectMap = (Map)obj;
            objectMap.put(alias.toLowerCase(), value);
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>(aliases.length);
        StandardAliasTransformer.runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

