/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.dialect;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.dialect.MyOracle10gDialect;
import com.af.v4.system.common.jpa.dialect.MySQLDialect;
import com.af.v4.system.common.jpa.dialect.MySqlServerDialect;
import com.af.v4.system.common.jpa.dialect.MySqlServerDialect2;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.SQLServer2016Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

public final class MyDialectResolver
implements DialectResolver {
    public Dialect resolveDialect(DialectResolutionInfo info) {
        for (Database database : Database.values()) {
            Dialect dialect = database.resolveDialect(info);
            if (dialect == null) continue;
            if (dialect instanceof SQLServerDialect) {
                if (dialect instanceof SQLServer2016Dialect) {
                    return new MySqlServerDialect2();
                }
                return new MySqlServerDialect();
            }
            if (dialect instanceof org.hibernate.dialect.MySQLDialect) {
                return new MySQLDialect();
            }
            if (dialect instanceof Oracle8iDialect) {
                return new MyOracle10gDialect();
            }
            try {
                return (Dialect)Class.forName(DynamicDataSource.getDruidDataSource().getDialect()).getConstructors()[0].newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

