/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.action;

import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.transformer.AliasTransformer;
import com.af.v4.system.common.jpa.transformer.StandardAliasTransformer;
import com.af.v4.system.common.jpa.transformer.TransformerSupport;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Component;

@Component
public class SqlAction
implements TransformerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlAction.class);
    private final SessionPool sessionPool;
    private final ThreadLocal<Boolean> useStandardTransformerThreadLocal = new ThreadLocal();

    public SqlAction(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JSONArray query(String name, String sql) {
        return this.query(name, sql, 0, 1000);
    }

    public JSONArray queryAll(String name, String sql) {
        return this.query(name, sql, null, null);
    }

    public JSONArray query(String name, String sql, Integer pageNo, Integer pageSize) {
        return (JSONArray)this.sqlMonitor(() -> {
            AliasedTupleSubsetResultTransformer resultTransformer;
            boolean useStandardTransformer;
            Boolean userStandardTrans = this.useStandardTransformerThreadLocal.get();
            boolean bl = useStandardTransformer = userStandardTrans != null && userStandardTrans != false;
            if (useStandardTransformer) {
                this.useStandardTransformerThreadLocal.remove();
                resultTransformer = StandardAliasTransformer.INSTANCE;
            } else {
                resultTransformer = AliasTransformer.INSTANCE;
            }
            HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize, (ResultTransformer)resultTransformer);
            return sqlCall.doInHibernate(this.sessionPool.getSession());
        }, name, sql);
    }

    public int bulkSQLUpdate(String name, String sql) {
        return (Integer)this.sqlMonitor(() -> {
            Session session = this.sessionPool.getSession();
            NativeQuery queryObject = session.createNativeQuery(sql);
            return queryObject.executeUpdate();
        }, name, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sqlMonitor(Process process, String name, String sql) {
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        finally {
            long end = System.currentTimeMillis();
            LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL[" + name + "]\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sql + "\n}");
        }
    }

    @Override
    public void useStandardTransformer() {
        this.useStandardTransformerThreadLocal.set(true);
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    private static class HibernateSQLCall
    implements HibernateCallback<JSONArray> {
        final String sql;
        final Integer page;
        final Integer rows;
        public ResultTransformer transformer;

        public HibernateSQLCall(String sql, Integer page, Integer rows, ResultTransformer transformer) {
            this.sql = sql;
            this.page = page;
            this.rows = rows;
            this.transformer = transformer;
        }

        public JSONArray doInHibernate(Session session) {
            NativeQuery q = session.createNativeQuery(this.sql);
            q.setResultTransformer(this.transformer);
            try {
                List list = this.page == null || this.rows == null ? q.list() : q.setFirstResult(this.page * this.rows).setMaxResults(this.rows.intValue()).list();
                if (this.transformer instanceof StandardAliasTransformer) {
                    return new JSONArray().putAll((Collection)list);
                }
                return new JSONArray((Collection)list);
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

