package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

/**
 * 琉璃简单定时调度任务封装
 *
 * @author Mr.river
 * TODO 完善分批次执行Logic并抛出合理异常
 */
public abstract class GlazeBasicProcessor implements BasicProcessor {

    private final Logger LOGGER = LoggerFactory.getLogger(GlazeBasicProcessor.class);

    @Log(
            title = "执行简单定时调度任务",
            businessType = BusinessType.LOGIC
    )
    @Override
    public ProcessResult process(TaskContext taskContext) {
        JSONObject jobParams;
        if (taskContext.getJobParams() != null) {
            jobParams = new JSONObject(taskContext.getJobParams());
        } else {
            jobParams = new JSONObject();
        }
        try {
            return exec(jobParams);
        } catch (Exception e) {
            if (e instanceof LogicException ex) {
                LOGGER.error("定时业务执行失败：{}", ex.getStack());
            } else {
                LOGGER.error("定时业务执行失败", e);
            }
            return new ProcessResult(false, "定时业务执行失败:" + e.getMessage());
        }
    }

    abstract ProcessResult exec(JSONObject jobParams);
}
