package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.concurrent.LogicBatchTaskProcessor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;

/**
 * 分批次执行数据的Logic定时调度任务封装
 *
 * @author Mr.river
 */
@Component
public class BatchLogicTimer extends GlazeBasicTimer {

    private final Logger LOGGER = LoggerFactory.getLogger(BatchLogicTimer.class);

    protected final LogicService logicService;

    /**
     * 获取批量数据的Logic名称
     */
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_NAME = "getBatchDataLogicName";

    /**
     * 获取批量数据的Logic参数
     */
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_PARAMS = "getBatchDataLogicParams";

    /**
     * 处理数据的Logic名称
     */
    private static final String PARAMS_HANDLE_DATA_LOGIC_NAME = "handleDataLogicName";

    public BatchLogicTimer(LogResolveService logResolveService, LogicService logicService) {
        super(logResolveService);
        this.logicService = logicService;
    }

    @Override
    public ProcessResult exec(JSONObject jobParams) {
        LogicBatchTaskProcessor processor = new LogicBatchTaskProcessor();
        JSONArray batchData = (JSONArray) logicService.run(
                jobParams.getString(PARAMS_GET_BATCH_DATA_LOGIC_NAME),
                jobParams.getJSONObject(PARAMS_GET_BATCH_DATA_LOGIC_PARAMS)
        );

        JSONObject result = processor.process(batchData, (JSONObject item) -> {
            String logicName = jobParams.getString(PARAMS_HANDLE_DATA_LOGIC_NAME);
            return logicService.run(logicName, item);
        });
        return new ProcessResult(true, result.toString());
    }
}
