package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.logic.service.LogicService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;

/**
 * 简单的通用Logic定时调度任务封装
 *
 * @author Mr.river
 */
@Component
public class SimpleLogicTimer extends GlazeBasicTimer {

    private final Logger LOGGER = LoggerFactory.getLogger(SimpleLogicTimer.class);

    protected final LogicService logicService;

    /**
     * 执行业务的Logic名称
     */
    private static final String PARAMS_LOGIC_NAME = "logicName";

    /**
     * 执行业务的Logic参数
     */
    private static final String PARAMS_LOGIC_PARAMS = "logicParams";

    public SimpleLogicTimer(LogicService logicService) {
        this.logicService = logicService;
    }

    @Override
    ProcessResult exec(JSONObject jobParams) {
        String logicName = jobParams.getString(PARAMS_LOGIC_NAME);
        JSONObject logicParams = jobParams.getJSONObject(PARAMS_LOGIC_PARAMS);
        Object result = logicService.run(logicName, logicParams);
        return new ProcessResult(true, result.toString());
    }
}
