/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.job;

import javax.annotation.PostConstruct;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import tech.powerjob.client.PowerJobClient;
import tech.powerjob.common.enums.ExecuteType;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.response.JobInfoDTO;
import tech.powerjob.common.response.ResultDTO;

@Component
public class PowerJobClientStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerJobClientStarter.class);
    @Value(value="${powerjob.worker.app-name}")
    private String appName;
    @Value(value="${powerjob.worker.server-address}")
    private String serverAddress;
    @Value(value="${powerjob.worker.password}")
    private String password;
    private PowerJobClient powerJobClient;

    @PostConstruct
    public void init() {
        try {
            this.powerJobClient = new PowerJobClient(this.serverAddress, this.appName, this.password);
        }
        catch (PowerJobException e) {
            LOGGER.error("PowerJob\u670d\u52a1\u7aef\u672a\u542f\u52a8\uff0c\u5b9a\u65f6\u4efb\u52a1\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
        }
    }

    public PowerJobClient getPowerJobClient() {
        return this.powerJobClient;
    }

    public ResultDTO<Long> createSimpleJob(String jobName, String jobDescription, JSONObject jobParams, TimeExpressionType timeExpressionType, String timeExpression, Class<?> jobClass) {
        SaveJobInfoRequest saveJobInfoRequest = new SaveJobInfoRequest();
        saveJobInfoRequest.setJobName(jobName);
        saveJobInfoRequest.setJobDescription(jobDescription);
        saveJobInfoRequest.setJobParams(jobParams.toString());
        saveJobInfoRequest.setTimeExpressionType(timeExpressionType);
        saveJobInfoRequest.setTimeExpression(timeExpression);
        saveJobInfoRequest.setExecuteType(ExecuteType.STANDALONE);
        saveJobInfoRequest.setProcessorType(ProcessorType.BUILT_IN);
        saveJobInfoRequest.setProcessorInfo(jobClass.getCanonicalName());
        saveJobInfoRequest.setMaxInstanceNum(Integer.valueOf(1));
        return this.powerJobClient.saveJob(saveJobInfoRequest);
    }

    public boolean hasJob(Long powerJobId) {
        ResultDTO resultDTO = this.powerJobClient.fetchJob(powerJobId);
        return resultDTO.isSuccess() && resultDTO.getData() != null && ((JobInfoDTO)resultDTO.getData()).getStatus() != 99;
    }
}

