package com.af.v4.system.common.gpt.service;

import com.af.v4.system.common.core.constant.CodeNormsConstants;
import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.PromptMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor = Exception.class)
public class PromptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromptService.class);
    private final PromptMapper promptMapper;

    public PromptService(PromptMapper promptMapper) {
        this.promptMapper = promptMapper;
    }

    /**
     * 获取Prompt
     *
     * @param name prompt名称
     * @return 执行结果
     */
    public String get(String name) {
        // 获取源程序内容
        AbstractResourceMapper.CommonResource<String> commonResource = promptMapper.getValue(name);
        String path = commonResource.getPath();
        name = commonResource.getAlias();
        LOGGER.info(CodeNormsConstants.DEBUG_PREFIX + "开始获取Prompt[" + name + "]");
        if (path == null) {
            throw new ServiceException("Prompt未找到: " + name, HttpStatus.BAD_REQUEST);
        }
        return ResourceIndexer.getString(ResourceType.PROMPT, name, path);
    }
}
