package com.af.v4.system.common.gpt.service;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.service.LiuLiConfigService;
import com.af.v4.system.common.plugins.http.RestTools;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * GPT服务
 */
@Service
public class GPTService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GPTService.class);
    private static final String GPT_SERVER_URL = "gptServerUrl";
    private final LiuLiConfigService liuLiConfigService;

    public GPTService(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    /**
     * 请求GPT服务
     *
     * @param content 请求内容
     * @return 请求结果
     */
    public String post(String content) {
        JSONObject config = liuLiConfigService.get(GPT_SERVER_URL);
        if (config == null) {
            throw new ServiceException("未配置GPT服务端地址", HttpStatus.CONFIG_ERROR);
        }
        String url = config.getString("value");
        String result = RestTools.postByFormData(url, new JSONObject().put("content", content));
        // 处理结果
        if (result.contains("INTERNAL SERVER ERROR")) {
            result = "GPT接口请求失败";
        }
        return result;
    }
}
