/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.gpt.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.PromptMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class PromptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromptService.class);
    private final PromptMapper promptMapper;

    public PromptService(PromptMapper promptMapper) {
        this.promptMapper = promptMapper;
    }

    public String get(String name) {
        AbstractResourceMapper.CommonResource commonResource = this.promptMapper.getValue(name);
        String path = (String)commonResource.getPath();
        name = commonResource.getAlias();
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f: \u5f00\u59cb\u83b7\u53d6Prompt[" + name + "]");
        if (path == null) {
            throw new ServiceException("Prompt\u672a\u627e\u5230: " + name, Integer.valueOf(400));
        }
        return ResourceIndexer.getString((ResourceType)ResourceType.PROMPT, (String)name, (String)path);
    }
}

