package com.af.v4.system.common.gpt.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.PromptMapper;
import com.af.v4.system.common.resource.mapper.ResourceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor = Exception.class)
public class PromptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromptService.class);
    private final ResourceMapper resourceMapper;
    private final PromptMapper promptMapper;

    public PromptService(ResourceMapper resourceMapper, PromptMapper promptMapper) {
        this.resourceMapper = resourceMapper;
        this.promptMapper = promptMapper;
    }

    /**
     * 获取Prompt
     *
     * @param name prompt名称
     * @return 执行结果
     */
    public String get(String name) {
        // 获取源程序内容
        AbstractResourceMapper.CommonResource<String> commonResource = promptMapper.getValue(name);
        String path = commonResource.getPath();
        name = commonResource.getAlias();
        LOGGER.info("维护信息:开始获取Prompt[" + name + "]");
        if (path == null) {
            throw new ServiceException("Prompt未找到: " + name);
        }
        return resourceMapper.getString(ResourceType.PROMPT, name, path);
    }
}
