/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.utils;

import com.af.v4.system.common.core.constant.FileConstants;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.resource.config.ResourceConfig;
import java.io.File;
import org.springframework.stereotype.Component;

@Component
public final class FilePathUtil {
    private final ApplicationUtils applicationUtils;
    private final ResourceConfig resourceConfig;

    public FilePathUtil(ApplicationUtils applicationUtils, ResourceConfig resourceConfig) {
        this.applicationUtils = applicationUtils;
        this.resourceConfig = resourceConfig;
    }

    public static String fileExt(String filename) {
        String[] array = filename.split("\\.");
        return array[array.length - 1].toLowerCase();
    }

    public String getFileRootPathByServer() {
        Object rootPath = this.resourceConfig.getFileRootPath();
        if (rootPath == null) {
            OSTypeEnum osType = ApplicationUtils.getOSType();
            rootPath = osType == OSTypeEnum.WINDOWS ? "D:" + File.separatorChar + "resources" : File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "tomcat" + File.separatorChar + "files";
        }
        return rootPath;
    }

    public String getFileExtraPathByServer(String resourceType) {
        return File.separatorChar + this.applicationUtils.getApplicationName() + File.separatorChar + (String)FileConstants.RESOURCE_TYPE_2_DIR.get(resourceType);
    }

    public String getFileFullPathByServer(String resourceType, String fileName) {
        return this.getFileRootPathByServer() + this.getFileExtraPathByServer(resourceType) + fileName;
    }

    public String getFileDownloadUrlByServer(String resourceType, String fileName) {
        return "/resource" + this.getFileExtraPathByServer(resourceType) + fileName;
    }

    public String getFileExtraPathBySSO(String resourceType) {
        return (String)FileConstants.RESOURCE_TYPE_2_DIR.get(resourceType);
    }

    public String getFileFullPathBySSO(String resourceType, String fileName) {
        return this.getFileExtraPathBySSO(resourceType) + fileName;
    }

    public String getFileDownloadUrlBySSO(String resourceType, String fileName) {
        return "/minio/" + this.getFileFullPathBySSO(resourceType, fileName);
    }
}

