package com.af.v4.system.common.file.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix = "minio")
@Configuration
public class MinioConfig {
    private static final Logger logger = LoggerFactory.getLogger(MinioConfig.class);

    private String url;

    private String access_key;

    private String secret_key;

    @Bean
    public MinioClient minioClient() {
        MinioClient minioClient;
        try {
            minioClient = MinioClient.builder()
                    .endpoint(url)
                    .credentials(access_key, secret_key)
                    .build();
        } catch (Exception e) {
            logger.warn("无minio相关配置，minio无法使用");
            return MinioClient.builder().endpoint("null").build();
        }
        return minioClient;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAccess_key(String access_key) {
        this.access_key = access_key;
    }

    public void setSecret_key(String secret_key) {
        this.secret_key = secret_key;
    }
}
