/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.entity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.multipart.MultipartFile;

public class TextMultipartFile
implements MultipartFile {
    private final String fileName;
    private final byte[] content;
    private final String contentType;

    public TextMultipartFile(String fileName, String content) {
        this.fileName = fileName;
        this.content = content.getBytes(StandardCharsets.UTF_8);
        this.contentType = "text/plain";
    }

    @NotNull
    public String getName() {
        return this.fileName;
    }

    public String getOriginalFilename() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    @NotNull
    public byte[] getBytes() {
        return this.content;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException {
        try (InputStream in = this.getInputStream();){
            Files.copy(in, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

