/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.config;

import io.minio.MinioClient;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="minio")
@Configuration
public class MinioConfig {
    private static final Logger logger = LoggerFactory.getLogger(MinioConfig.class);
    private String url;
    private String access_key;
    private String secret_key;

    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, MinioConfig.getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static TrustManager[] getTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }

    public static HostnameVerifier getHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    public static X509TrustManager getX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
        return trustManager;
    }

    public static OkHttpClient getUnsafeOkHttpClient() throws NoSuchAlgorithmException, KeyStoreException {
        return new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).sslSocketFactory(MinioConfig.getSSLSocketFactory(), MinioConfig.getX509TrustManager()).hostnameVerifier(MinioConfig.getHostnameVerifier()).build();
    }

    @Bean
    public MinioClient minioClient() {
        MinioClient minioClient;
        try {
            minioClient = MinioClient.builder().httpClient(MinioConfig.getUnsafeOkHttpClient()).endpoint(this.url).credentials(this.access_key, this.secret_key).build();
        }
        catch (Exception e) {
            logger.warn("\u65e0minio\u76f8\u5173\u914d\u7f6e\uff0cminio\u65e0\u6cd5\u4f7f\u7528");
            return MinioClient.builder().endpoint("null").build();
        }
        return minioClient;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAccess_key(String access_key) {
        this.access_key = access_key;
    }

    public void setSecret_key(String secret_key) {
        this.secret_key = secret_key;
    }
}

