/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.service;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.constant.FileConstants;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.jpa.IEntityServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.file.entity.TextMultipartFile;
import com.af.v4.system.common.file.entity.UploadFileInfo;
import com.af.v4.system.common.file.enums.ResUploadModeEnum;
import com.af.v4.system.common.file.service.MinioService;
import com.af.v4.system.common.file.utils.FilePathUtil;
import com.af.v4.system.common.plugins.core.CalculateUtil;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileService.class);
    private final IEntityServiceProxy entityService;
    private final MinioService minioService;
    private final ApplicationService applicationService;
    private final FilePathUtil filePathUtil;

    public FileService(IEntityServiceProxy entityService, MinioService minioService, ApplicationService applicationService, FilePathUtil filePathUtil) {
        this.entityService = entityService;
        this.minioService = minioService;
        this.applicationService = applicationService;
        this.filePathUtil = filePathUtil;
    }

    public FileUploadResult uploadFile(MultipartFile file, String resUploadMode, String operator, String formType, String useType, String bucketName, String saveName) {
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        String fileName = file.getOriginalFilename();
        assert (fileName != null);
        UploadFileInfo fileInfo = new UploadFileInfo();
        fileInfo.setSize(CalculateUtil.div((Object)file.getSize(), (Object)0x100000, (Integer)4));
        fileInfo.setExtension(FilePathUtil.fileExt(fileName));
        fileInfo.setResourceType((String)FileConstants.RESOURCE_EXT_2_TYPE.get(fileInfo.getExtension()));
        if (fileInfo.getResourceType() == null) {
            throw new ServiceException("\u5f53\u524d\u8d44\u6e90\u7c7b\u578b\u4e0d\u652f\u6301\u4e0a\u4f20\uff1a" + fileInfo.getExtension());
        }
        fileInfo.setOriginalName(fileName.replaceAll("(?i)." + fileInfo.getExtension(), ""));
        fileInfo.setSaveName(Objects.requireNonNullElseGet(saveName, () -> CommonTools.getUUID((Boolean)true) + "." + fileInfo.getExtension()));
        return switch (resUploadTypeEnum) {
            case ResUploadModeEnum.SERVER -> {
                fileInfo.setExtraPath(this.filePathUtil.getFileExtraPathByServer(fileInfo.getResourceType()));
                fileInfo.setSavePath(this.filePathUtil.getFileFullPathByServer(fileInfo.getResourceType(), fileInfo.getSaveName()));
                Map<String, Object> entity = this.uploadFileToServer(file, fileInfo, operator, formType, useType);
                yield new FileUploadResult(true, entity);
            }
            case ResUploadModeEnum.BASE64 -> {
                Map<String, Object> entity = this.uploadFileToBase64(file);
                yield new FileUploadResult(true, entity);
            }
            default -> {
                fileInfo.setExtraPath(this.filePathUtil.getFileExtraPathBySSO(fileInfo.getResourceType(), bucketName));
                fileInfo.setSavePath(this.filePathUtil.getFileFullPathBySSO(fileInfo.getResourceType(), fileInfo.getSaveName(), bucketName));
                Map<String, Object> entity = this.uploadFileToOSS(file, fileInfo, operator, formType, useType, bucketName);
                yield new FileUploadResult(true, entity);
            }
        };
    }

    public FileUploadResult uploadFile(MultipartFile file, String resUploadMode, String operator, String formType, String useType) {
        return this.uploadFile(file, resUploadMode, operator, formType, useType, null, null);
    }

    public FileUploadResult uploadFile(MultipartFile file, String resUploadMode) {
        return this.uploadFile(file, resUploadMode, null, null, null);
    }

    public FileUploadResult uploadText(String content, String fileName, String resUploadMode, String operator, String formType, String useType, String bucketName, String saveName) {
        TextMultipartFile file = new TextMultipartFile(fileName, content);
        return this.uploadFile(file, resUploadMode, operator, formType, useType, bucketName, saveName);
    }

    public FileUploadResult uploadText(String content, String fileName, String resUploadMode) {
        return this.uploadText(content, fileName, resUploadMode, null, null, null, null, null);
    }

    private Map<String, Object> uploadFileToServer(MultipartFile file, UploadFileInfo fileInfo, String operator, String formType, String useType) {
        String path = fileInfo.getSavePath();
        File fileDir = new File(path);
        try {
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)fileDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String downloadPath = this.filePathUtil.getFileDownloadUrlByServer(fileInfo.getResourceType(), fileInfo.getSaveName());
        return this.saveFileEntity(ResUploadModeEnum.SERVER, fileInfo, downloadPath, path, operator, formType, useType);
    }

    private Map<String, Object> uploadFileToBase64(MultipartFile file) {
        try {
            HashMap<String, Object> message = new HashMap<String, Object>(1);
            message.put("base64", ConvertTools.base64Encode((byte[])file.getBytes()));
            return message;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> uploadFileToOSS(MultipartFile file, UploadFileInfo fileInfo, String operator, String formType, String useType, String bucketName) {
        if (bucketName == null) {
            bucketName = this.applicationService.getApplicationName();
        }
        try {
            this.minioService.upload(file, fileInfo.getSavePath(), bucketName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String downloadPath = this.filePathUtil.getFileDownloadUrlBySSO(fileInfo.getResourceType(), fileInfo.getSaveName(), bucketName);
        return this.saveFileEntity(ResUploadModeEnum.OSS, fileInfo, downloadPath, fileInfo.getSavePath(), operator, formType, useType);
    }

    public FileUploadResult deleteFile(Integer id, String resUploadMode) {
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        JSONObject row = new JSONObject();
        row.put("id", (Object)id);
        row.put("f_state", (Object)"\u5220\u9664");
        JSONObject entityResult = this.entityService.partialSave("t_files", row);
        FileUploadResult result = new FileUploadResult(true, entityResult.toMap());
        switch (resUploadTypeEnum) {
            case SERVER: {
                break;
            }
            case BASE64: {
                break;
            }
        }
        return result;
    }

    private Map<String, Object> saveFileEntity(ResUploadModeEnum resUploadModeEnum, UploadFileInfo fileInfo, String downloadPath, String realPath, String operator, String formType, String useType) {
        LoginUser loginUser;
        JSONObject filesEntity = new JSONObject();
        if (operator == null && (loginUser = SecurityUtils.getLoginUser()) != null) {
            operator = loginUser.getUsername();
        }
        if (useType == null) {
            useType = "Default";
        }
        if (formType == null) {
            formType = "file";
        }
        filesEntity.put("f_filename", (Object)fileInfo.getSaveName());
        filesEntity.put("f_stock_id", 0);
        filesEntity.put("f_filetype", (Object)fileInfo.getExtension());
        filesEntity.put("f_downloadpath", (Object)downloadPath);
        filesEntity.put("f_realpath", (Object)realPath);
        filesEntity.put("f_file_size", (Object)fileInfo.getSize());
        filesEntity.put("f_operator", (Object)operator);
        filesEntity.put("f_form_type", (Object)formType);
        filesEntity.put("f_type", (Object)fileInfo.getResourceType());
        filesEntity.put("f_use_type", (Object)useType);
        filesEntity.put("f_upload_mode", (Object)resUploadModeEnum.getValue());
        filesEntity.put("fusetype", (Object)useType);
        filesEntity.put("id", (Object)this.entityService.partialSave("t_files", filesEntity).getString("id"));
        return filesEntity.toMap();
    }

    public static class FileUploadResult {
        private final Boolean isSuccess;
        private final Map<String, Object> data;

        private FileUploadResult(boolean isSuccess, Map<String, Object> data) {
            this.isSuccess = isSuccess;
            this.data = data;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public Object getData() {
            return this.data;
        }

        public JSONObject toJson() {
            return new JSONObject().put("isSuccess", (Object)this.isSuccess).put("data", this.data);
        }
    }
}

