package com.af.v4.system.common.file.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix = "minio")
@Configuration
@Component
public class MinioConfig {
    private static final Logger logger = LoggerFactory.getLogger(MinioConfig.class);
    private String url;

    private String access_key;

    private String secret_key;

    @Bean
    public MinioClient minioClient() {
        MinioClient minioClient = null;
        try {
            minioClient = MinioClient.builder()
                    .endpoint(url)
                    .credentials(access_key, secret_key)
                    .build();
        } catch (Exception e) {
            logger.warn("无法初始化minio，将无法使用minio相关的功能！");
            return MinioClient.builder().endpoint("null").build();
        }
        logger.info("初始化minio已完成！");
        return minioClient;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAccess_key(String access_key) {
        this.access_key = access_key;
    }

    public void setSecret_key(String secret_key) {
        this.secret_key = secret_key;
    }
}
