/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.file.enums.ResUploadModeEnum;
import com.af.v4.system.common.file.service.MinioService;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.plugins.core.CalculateUtil;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.resource.config.ResourceConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileService.class);
    private static final String STATIC_RES_URL = "/resource";
    private final EntityService entityService;
    private final MinioService minioService;
    private final ResourceConfig resourceConfig;

    public FileService(EntityService entityService, MinioService minioService, ResourceConfig resourceConfig) {
        this.entityService = entityService;
        this.minioService = minioService;
        this.resourceConfig = resourceConfig;
    }

    public FileUploadResult uploadFile(MultipartFile file, String resUploadMode, int stockId, String operator, String pathKey, String formType, String useType, String bucketName) {
        JSONArray extraPathKeys;
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            return new FileUploadResult(false, "\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        JSONObject stock = new JSONObject();
        if (stockId > 0) {
            JSONObject response = this.entityService.remoteGetById("af-system", "f_root_path, f_alias, f_lower_path_json", "t_files_manager", (Object)stockId);
            if (response.getInt("status") != 200) {
                String msg = response.optString("msg", "unknown error");
                return new FileUploadResult(false, "\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\u5931\u8d25\uff1a" + msg);
            }
            stock = response.getJSONObject("data");
        }
        String rootPath = stock.optString("f_root_path", this.resourceConfig.getFileRootPath());
        String path = rootPath + stock.optString("f_alias", bucketName);
        String extraPathKey = null;
        if (pathKey != null && !(extraPathKeys = new JSONArray((Collection)new JSONArray(stock.getString("f_lower_path_json")).toList().stream().filter(item -> Objects.equals(((Map)item).get("label"), pathKey)).collect(Collectors.toList()))).isEmpty()) {
            extraPathKey = extraPathKeys.getJSONObject(0).getString("value");
        }
        String fileName = file.getOriginalFilename();
        BigDecimal fileSize = CalculateUtil.div((Object)file.getSize(), (Object)0x100000, (Integer)4);
        return switch (resUploadTypeEnum) {
            case ResUploadModeEnum.SERVER -> {
                if (!$assertionsDisabled && fileName == null) {
                    throw new AssertionError();
                }
                Map<String, Object> entity = this.uploadFileToServer(file, stockId, rootPath, path, extraPathKey, fileName, fileSize, operator, formType, useType);
                yield new FileUploadResult(true, entity);
            }
            case ResUploadModeEnum.BASE64 -> {
                Map<String, Object> entity = this.uploadFileToBase64(file);
                yield new FileUploadResult(true, entity);
            }
            case ResUploadModeEnum.OSS -> {
                Map<String, Object> entity = this.uploadFileToOSS(file, stockId, rootPath, path, extraPathKey, fileName, fileSize, operator, formType, useType, bucketName);
                yield new FileUploadResult(true, entity);
            }
            default -> throw new ServiceException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6a21\u5f0f\uff1a" + resUploadTypeEnum.getValue(), Integer.valueOf(400));
        };
    }

    public Map<String, Object> uploadFileToServer(MultipartFile file, int f_stock_id, String rootPath, String path, String extraPathKey, String filename, BigDecimal filesize, String operator, String formType, String useType) {
        String fileSuffix = filename.substring(filename.lastIndexOf(46) + 1);
        if (extraPathKey != null) {
            path = (String)path + File.separator + extraPathKey;
        }
        String fileName = CommonTools.getUUID((Boolean)true) + "." + fileSuffix;
        path = (String)path + File.separator + DateTools.getNow((String)"yyyyMMdd") + File.separator + fileName;
        File fileDir = new File((String)path);
        try {
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)fileDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject files_entity = new JSONObject();
        String downloadPath = "/resource/" + ((String)path).replace(File.separator, "/").substring(rootPath.length());
        files_entity.put("f_filename", (Object)filename);
        files_entity.put("f_stock_id", f_stock_id);
        files_entity.put("f_filetype", (Object)fileSuffix);
        files_entity.put("f_downloadpath", (Object)downloadPath);
        files_entity.put("f_realpath", path);
        files_entity.put("f_file_size", (Object)filesize);
        files_entity.put("f_operator", (Object)operator);
        files_entity.put("f_form_type", (Object)formType);
        files_entity.put("f_use_type", (Object)useType);
        files_entity.put("fusetype", (Object)useType);
        try {
            files_entity.put("id", (Object)this.entityService.partialSave("t_files", files_entity).getString("id"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return files_entity.toMap();
    }

    public Map<String, Object> uploadFileToBase64(MultipartFile file) {
        try {
            HashMap<String, Object> message = new HashMap<String, Object>(1);
            message.put("base64", ConvertTools.base64Encode((byte[])file.getBytes()));
            return message;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> uploadFileToOSS(MultipartFile file, int f_stock_id, String rootPath, String path, String extraPathKey, String filename, BigDecimal filesize, String operator, String formType, String useType, String BucketName) {
        String fileSuffix = filename.substring(filename.lastIndexOf(46) + 1);
        String fileName = CommonTools.getUUID((Boolean)true) + "." + fileSuffix;
        if (formType.equals("image")) {
            fileName = "images/" + fileName;
        }
        try {
            this.minioService.upload(file, fileName, BucketName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JSONObject files_entity = new JSONObject();
        String downloadPath = "/oss/" + BucketName + "/" + fileName;
        String realPath = "Minio/" + BucketName + "/" + fileName;
        files_entity.put("f_filename", (Object)filename);
        files_entity.put("f_stock_id", f_stock_id);
        files_entity.put("f_filetype", (Object)fileSuffix);
        files_entity.put("f_downloadpath", (Object)downloadPath);
        files_entity.put("f_realpath", (Object)realPath);
        files_entity.put("f_file_size", (Object)filesize);
        files_entity.put("f_operator", (Object)operator);
        files_entity.put("f_form_type", (Object)formType);
        files_entity.put("f_use_type", (Object)useType);
        files_entity.put("fusetype", (Object)useType);
        try {
            files_entity.put("id", (Object)this.entityService.partialSave("t_files", files_entity).getString("id"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return files_entity.toMap();
    }

    public FileUploadResult deleteFile(Integer id, String resDeleteMode) {
        FileUploadResult result;
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resDeleteMode);
        if (resUploadTypeEnum == null) {
            return new FileUploadResult(false, "\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resDeleteMode);
        }
        switch (resUploadTypeEnum) {
            case SERVER: {
                JSONObject row = new JSONObject();
                row.put("id", (Object)id);
                row.put("f_state", (Object)"\u5220\u9664");
                try {
                    JSONObject jsonObject = this.entityService.partialSave("t_files", row);
                    result = new FileUploadResult(true, jsonObject);
                    break;
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException("\u5b9e\u4f53t_files\u4e0d\u5b58\u5728, {}", e);
                }
            }
            case BASE64: {
                result = new FileUploadResult(true, "BASE64");
                break;
            }
            case OSS: {
                result = new FileUploadResult(true, "OSS");
                break;
            }
            default: {
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6a21\u5f0f\uff1a" + resUploadTypeEnum.getValue(), Integer.valueOf(400));
            }
        }
        return result;
    }

    public static class FileUploadResult {
        private final Boolean isSuccess;
        private final Object data;

        private FileUploadResult(boolean isSuccess, Object data) {
            this.isSuccess = isSuccess;
            this.data = data;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public Object getData() {
            return this.data;
        }
    }
}

