package com.af.v4.system.common.expression.report.core;

import org.dom4j.Element;

// 报表中用到的sql或者业务逻辑查询
public class Sql {
    // sql语句对应的变量名，方便单元格调用
    public final String name;

    // sql或者业务逻辑路径
    public final String sql;

    // sql或者业务逻辑参数
    public final String param;

    // 从xml元素中加载sql
    public Sql(Element ele) {
        this.name = ele.attributeValue("name");
        this.sql = ele.attributeValue("sql");
        this.param = ele.attributeValue("param");
    }

    public Sql(String name, String sql, String param) {
        this.name = name;
        this.sql = sql;
        this.param = param;
    }
}
