/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.core;

import com.af.v4.system.common.expression.core.Expression;
import com.af.v4.system.common.expression.exception.ReturnWayException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.json.JSONObject;

public class Delegate
implements Function<JSONObject, Object> {
    private final Expression exp;
    private final String source;
    private final List<String> lambdaOutProps = new ArrayList<String>();
    private Map<String, Object> objectNames = new HashMap<String, Object>(32);

    Delegate(Expression exp, String source) {
        this.exp = exp;
        this.source = source;
    }

    Delegate(Expression exp, String source, Map<String, Object> objectNames) {
        this.exp = exp;
        this.source = source;
        this.objectNames = objectNames;
    }

    public Object invoke() {
        return this.invoke(new HashMap<String, Object>(32));
    }

    public Object invoke(Map<String, Object> params) {
        this.objectNames = params;
        this.putDelegate(this.exp);
        try {
            return this.exp.invoke();
        }
        catch (ReturnWayException returnWay) {
            return returnWay.getReturnObject();
        }
    }

    private void putDelegate(Expression parent) {
        for (Expression child : parent.children) {
            if (child == null) continue;
            if ("Try".equals(child.type.name())) {
                Expression[] exps = (Expression[])child.value;
                assert (exps != null);
                if (exps[0] != null) {
                    exps[0].setDelegate(this);
                    this.putDelegate(exps[0]);
                }
                if (exps[1] != null) {
                    exps[1].setDelegate(this);
                    this.putDelegate(exps[1]);
                }
            }
            child.setDelegate(this);
            this.putDelegate(child);
        }
    }

    Expression getExp() {
        return this.exp;
    }

    Map<String, Object> getObjectNames() {
        return this.objectNames;
    }

    List<String> getLambdaOutProps() {
        return this.lambdaOutProps;
    }

    void put(String key, Object value) {
        this.objectNames.put(key, value);
    }

    Object get(String key) {
        return this.objectNames.get(key);
    }

    boolean containsKey(String key) {
        return this.objectNames.containsKey(key);
    }

    String getSource() {
        return this.source;
    }

    public Object apply() {
        return this.apply(null);
    }

    @Override
    public Object apply(JSONObject params) {
        if (params == null) {
            params = new JSONObject();
        }
        Map<String, Object> map = this.objectNames;
        if (this.lambdaOutProps.isEmpty()) {
            this.lambdaOutProps.addAll(map.keySet());
        }
        HashMap<String, Object> lambdaMap = new HashMap<String, Object>(map);
        lambdaMap.put("data", params);
        return this.invoke(lambdaMap);
    }
}

