package com.af.v4.system.common.expression;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;

import java.util.Map;

/**
 * 表达式执行入口
 *
 * @author LocalUser
 */
public class Expression {

    /**
     * 带参运行表达式
     *
     * @param source 表达式源码
     * @param params 表达式参数
     */
    public static Object run(String source, Map<String, Object> params) {
        Delegate delegate = getDelegate(source);
        return delegate.invoke(params);
    }

    public static Delegate getDelegate(String source) {
        // 解析
        return new Program(source).parse();
    }
}
