/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.report.core;

import com.af.v4.system.common.expression.report.core.Block;
import com.af.v4.system.common.expression.report.core.Cell;
import com.af.v4.system.common.expression.report.core.Report;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Element;
import org.json.JSONArray;

public class HeadBlock
extends Block {
    public Cell headCell;
    public String name;
    public Object data;

    public HeadBlock(Element ele) {
        super(ele);
        for (Element obj : ele.elements("headblock")) {
            this.cells.add(new HeadBlock(obj));
        }
        this.name = ele.attributeValue("name");
        Element eHead = ele.element("head");
        if (eHead != null) {
            this.headCell = new Cell(eHead);
        }
    }

    public HeadBlock(int row, int column, int rowSpan, int columnSpan, String content) {
        super(row, column, rowSpan, columnSpan, content);
    }

    public void setColumn(int column) {
        for (Cell cell : this.cells) {
            cell.column += column;
            if (!(cell instanceof HeadBlock)) continue;
            HeadBlock block = (HeadBlock)cell;
            block.setColumn(column);
        }
        if (this.headCell != null) {
            this.headCell.column += column;
        }
    }

    public void setRow(int row) {
        for (Cell cell : this.cells) {
            cell.row += row;
            if (!(cell instanceof HeadBlock)) continue;
            HeadBlock block = (HeadBlock)cell;
            block.setColumn(row);
        }
        if (this.headCell != null) {
            this.headCell.row += row;
        }
    }

    @Override
    public void compile() {
        super.compile();
        if (this.headCell != null) {
            this.headCell.compile();
        }
    }

    @Override
    public void setReport(Report report) {
        super.setReport(report);
        if (this.headCell != null) {
            this.headCell.setReport(report);
        }
    }

    public int createCell(List<Cell> result) {
        this.cells.sort(Comparator.comparingInt(o -> o.row * 10000 + o.column));
        int copyColumn = 0;
        for (Cell cell : this.cells) {
            if (cell instanceof HeadBlock) {
                HeadBlock block = (HeadBlock)cell;
                if (block.content != null && !block.content.trim().isEmpty()) {
                    int i = 0;
                    Object v = block.invoke();
                    if (v instanceof JSONArray) {
                        for (Object item : (JSONArray)v) {
                            HeadBlock newBlock = block.clone();
                            if (i != 0) {
                                copyColumn += block.columnSpan;
                            }
                            newBlock.setColumn(copyColumn);
                            ArrayList<Cell> cells = new ArrayList<Cell>();
                            newBlock.data = item;
                            this.report.vars.put(newBlock.name, item);
                            copyColumn += newBlock.createCell(cells);
                            result.addAll(cells);
                            ++i;
                        }
                        continue;
                    }
                    throw new RuntimeException("\u5fc5\u987b\u8fd4\u56deJSONArray\uff0c\u884c\uff1a" + block.row + ", \u5217\uff1a" + block.column + ", \u5185\u5bb9\uff1a" + block.content);
                }
                HeadBlock newBlock = block.clone();
                newBlock.setColumn(copyColumn);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                copyColumn += newBlock.createCell(cells);
                result.addAll(cells);
                continue;
            }
            cell.column += copyColumn;
            cell.content = cell.invoke().toString();
            result.add(cell);
        }
        if (this.headCell != null) {
            this.headCell.columnSpan += copyColumn;
            this.headCell.content = this.headCell.invoke().toString();
            result.add(this.headCell);
        }
        return copyColumn;
    }

    @Override
    public HeadBlock clone() {
        HeadBlock result = new HeadBlock(this.row, this.column, this.rowSpan, this.columnSpan, this.content);
        if (this.delegate != null) {
            result.delegate = this.delegate;
        }
        if (this.report != null) {
            result.report = this.report;
        }
        for (Cell cell : this.cells) {
            result.cells.add(cell.clone());
        }
        if (this.headCell != null) {
            result.headCell = this.headCell.clone();
        }
        if (this.name != null) {
            result.name = this.name;
        }
        return result;
    }
}

