/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.core;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Expression;
import com.af.v4.system.common.expression.core.ExpressionType;
import com.af.v4.system.common.expression.core.Token;
import com.af.v4.system.common.expression.core.TokenType;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import org.json.JSONArray;

public class Program {
    public final String SOURCE;
    public final Integer SOURCE_LENGTH;
    private final Queue<Token> tokens = new ArrayDeque<Token>();
    private final Deque<Boolean> inStrings = new ArrayDeque<Boolean>();
    private int pos;
    private boolean inString;

    public Program(String source) {
        this.SOURCE = source;
        this.SOURCE_LENGTH = this.SOURCE.length();
    }

    public Delegate parse() {
        return this.createDelegate(this.expression());
    }

    public Delegate parse(Expression expression) {
        return this.createDelegate(expression);
    }

    public Delegate createDelegate(Expression expression) {
        return new Delegate(expression, this.SOURCE);
    }

    public Expression expression() {
        Expression expression = this.CommaExp();
        if (this.pos < this.SOURCE_LENGTH) {
            throw new RuntimeException(this.GetExceptionMessage("\u9700\u8981\u9017\u53f7\u7ed3\u5c3e!"));
        }
        return expression;
    }

    private Expression CommaExp() {
        ArrayList<Expression> exps = new ArrayList<Expression>();
        Expression first = this.AssignExp();
        exps.add(first);
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && (",".equals(t.value()) || ";".equals(t.value()) || "\n".equals(t.value()))) {
            Expression r = this.AssignExp();
            exps.add(r);
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return Expression.Comma(exps, this.pos);
    }

    private Expression AssignExp() {
        Token t = this.GetToken();
        int firstPos = t.startPos();
        if (t.type() != TokenType.Identy) {
            this.pos = firstPos;
            this.tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        Expression objExp = Expression.Identity(t.value(), this.pos);
        objExp = this.ObjectPath(objExp);
        if (objExp.type != ExpressionType.Property && objExp.type != ExpressionType.Identity) {
            this.pos = firstPos;
            this.tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        t = this.GetToken();
        if (t.type() != TokenType.Oper || !"=".equals(t.value())) {
            this.pos = firstPos;
            this.tokens.clear();
            this.inString = false;
            return this.Exp();
        }
        Expression exp = this.Exp();
        if (objExp.type == ExpressionType.Property) {
            String name = (String)objExp.value;
            objExp = objExp.children.getFirst();
            return Expression.Assign(objExp, exp, name, this.pos);
        }
        return Expression.Assign(null, exp, objExp.value.toString(), this.pos);
    }

    private Expression Exp() {
        Expression v = this.Logic();
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && ":".equals(t.value())) {
            Expression result = this.Logic();
            t = this.GetToken();
            if (t.type() == TokenType.Oper && ",".equals(t.value())) {
                Expression sExp = this.Exp();
                return Expression.Condition(v, result, sExp, this.SOURCE, this.pos);
            }
            throw new RuntimeException(this.GetExceptionMessage("\u5fc5\u987b\u6709\u9ed8\u8ba4\u503c!"));
        }
        this.tokens.offer(t);
        return v;
    }

    private Expression Logic() {
        boolean hasNot;
        Token t = this.GetToken();
        boolean bl = hasNot = t.type() == TokenType.Oper && "!".equals(t.value());
        if (!hasNot) {
            this.tokens.offer(t);
        }
        Expression v = this.Compare();
        if (hasNot) {
            v = Expression.Not(v, this.SOURCE, this.pos);
        }
        t = this.GetToken();
        while (t.type() == TokenType.Oper && ("&&".equals(t.value()) || "||".equals(t.value()))) {
            Expression exp = this.Logic();
            v = "&&".equals(t.value()) ? Expression.And(v, exp, this.SOURCE, this.pos) : Expression.Or(v, exp, this.SOURCE, this.pos);
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return v;
    }

    private Expression Compare() {
        Expression left = this.Math();
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && (">".equals(t.value()) || ">=".equals(t.value()) || "<".equals(t.value()) || "<=".equals(t.value()) || "=>".equals(t.value()))) {
            if ("=>".equals(t.value())) {
                this.tokens.offer(t);
                return this.Lambda();
            }
            Expression rExp = this.Math();
            return switch (t.value().toString()) {
                case ">" -> Expression.GreaterThan(left, rExp, this.SOURCE, this.pos);
                case ">=" -> Expression.GreaterThanOrEqual(left, rExp, this.SOURCE, this.pos);
                case "<" -> Expression.LessThan(left, rExp, this.SOURCE, this.pos);
                default -> Expression.LessThanOrEqual(left, rExp, this.SOURCE, this.pos);
            };
        }
        if (t.type() == TokenType.Oper && ("==".equals(t.value()) || "!=".equals(t.value()))) {
            Expression rExp = this.Math();
            if ("==".equals(t.value())) {
                return Expression.Equal(left, rExp, this.SOURCE, this.pos);
            }
            return Expression.NotEqual(left, rExp, this.SOURCE, this.pos);
        }
        this.tokens.offer(t);
        return left;
    }

    private Expression Math() {
        Expression v = this.Mul();
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && ("+".equals(t.value()) || "-".equals(t.value()))) {
            Expression r = this.Mul();
            v = "+".equals(t.value()) ? Expression.Add(v, r, this.SOURCE, this.pos) : Expression.Subtract(v, r, this.SOURCE, this.pos);
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return v;
    }

    private Expression Lambda() {
        Token t = this.GetToken();
        if (t.value() != null && !"=>".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("lambda\u5fc5\u987b\u4ee5=>\u5f00\u59cb"));
        }
        t = this.GetToken();
        if (t.value() != null && !"{".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("lambda\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
        }
        Expression exp = this.CommaExp();
        t = this.GetToken();
        if (t.value() != null && !"}".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("lambda\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
        }
        return Expression.Lambda(exp, this.pos);
    }

    private Expression Mul() {
        Expression v = this.UnarySub();
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && ("*".equals(t.value()) || "/".equals(t.value()) || "%".equals(t.value()))) {
            Expression r = this.UnarySub();
            v = "*".equals(t.value()) ? Expression.Multiply(v, r, this.SOURCE, this.pos) : ("/".equals(t.value()) ? Expression.Divide(v, r, this.SOURCE, this.pos) : Expression.Modulo(v, r, this.SOURCE, this.pos));
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return v;
    }

    private Expression UnarySub() {
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && "-".equals(t.value())) {
            Expression r = this.Item();
            return Expression.Subtract(Expression.Constant(0, this.pos), r, this.SOURCE, this.pos);
        }
        this.tokens.offer(t);
        return this.Item();
    }

    private Expression Item() {
        StringBuilder objName = new StringBuilder();
        Expression objExp = this.ItemHead(objName);
        objExp = this.ObjectPath(objExp);
        return objExp;
    }

    private Expression ItemHead(StringBuilder name) {
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && "(".equals(t.value())) {
            Expression result = this.CommaExp();
            t = this.GetToken();
            if (t.type() != TokenType.Oper || !")".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("\u62ec\u53f7\u4e0d\u5339\u914d"));
            }
            return result;
        }
        if (t.type() == TokenType.Oper && "{".equals(t.value())) {
            return this.Json();
        }
        if (t.type() == TokenType.Oper && "[".equals(t.value())) {
            return this.JsonArray();
        }
        if (t.type() == TokenType.Oper && ("$".equals(t.value()) || "\"".equals(t.value()))) {
            return this.StringUnion();
        }
        if (t.type() == TokenType.Int || t.type() == TokenType.Double || t.type() == TokenType.Bool) {
            return Expression.Constant(t.value(), this.pos);
        }
        if (t.type() == TokenType.Identy) {
            String objName;
            switch (objName = (String)t.value()) {
                case "return": {
                    return Expression.Return(this.Exp(), this.pos);
                }
                case "try": {
                    this.tokens.offer(t);
                    return this.Try();
                }
                case "throw": {
                    return Expression.Throw(this.Exp(), this.pos);
                }
                case "validate": {
                    return this.Validate();
                }
                case "assert": {
                    return Expression.Assert(this.Exp(), this.pos);
                }
                case "break": {
                    return Expression.Break(null, this.pos);
                }
                case "continue": {
                    return Expression.Continue(null, this.pos);
                }
            }
            name.append(objName);
            return this.ObjectName(objName);
        }
        if (t.type() == TokenType.Null) {
            return Expression.Constant(null, this.pos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u5355\u8bcd\u7c7b\u578b\u9519\u8bef\uff1a" + String.valueOf((Object)t.type())));
    }

    private Expression Try() {
        Token t = this.GetToken();
        if (t.value() != null && !"try".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("try-catch\u5fc5\u987b\u4ee5try\u5f00\u59cb"));
        }
        t = this.GetToken();
        if (t.value() != null && !"{".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("try\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
        }
        Expression tryExp = this.CommaExp();
        t = this.GetToken();
        if (t.value() != null && !"}".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("try\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
        }
        List<Expression> catches = this.Catch();
        Expression finallyExp = null;
        t = this.GetToken();
        if (t.value() != null && "finally".equals(t.value())) {
            t = this.GetToken();
            if (!"{".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("finally\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
            }
            finallyExp = this.CommaExp();
            t = this.GetToken();
            if (!"}".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("finally\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
            }
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return Expression.Try(tryExp, finallyExp, catches, this.pos);
    }

    private List<Expression> Catch() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Token t = this.GetToken();
        while ("catch".equals(t.value())) {
            t = this.GetToken();
            if (!"(".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u53c2\u6570\u5fc5\u987b\u4ee5(\u5f00\u59cb"));
            }
            t = this.GetToken();
            String className = (String)t.value();
            t = this.GetToken();
            String varName = (String)t.value();
            t = this.GetToken();
            if (!")".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u53c2\u6570\u5fc5\u987b\u4ee5)\u7ed3\u675f"));
            }
            t = this.GetToken();
            if (!"{".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u5fc5\u987b\u4ee5{\u5f00\u59cb"));
            }
            Expression catchExp = this.CommaExp();
            result.add(Expression.Catch(className, varName, catchExp, this.pos));
            t = this.GetToken();
            if (!"}".equals(t.value())) {
                throw new RuntimeException(this.GetExceptionMessage("catch\u5757\u5fc5\u987b\u4ee5}\u7ed3\u675f"));
            }
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return result;
    }

    private Expression Validate() {
        Token t = this.GetToken();
        if (t.value() != null && !"{".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("validate\u53ea\u63a5\u6536Json\u5bf9\u8c61"));
        }
        Expression exp = this.Json();
        return Expression.Validate(exp, this.pos);
    }

    private Expression Json() {
        ArrayList<Expression> children = new ArrayList<Expression>();
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && "}".equals(t.value())) {
            return Expression.Json(children, this.pos);
        }
        this.tokens.offer(t);
        children.add(this.Attr());
        t = this.GetToken();
        while (t.type() == TokenType.Oper && ",".equals(t.value())) {
            Token nextT = this.GetToken();
            if (nextT.type() == TokenType.Oper && "}".equals(nextT.value())) {
                t = nextT;
                break;
            }
            this.tokens.offer(nextT);
            children.add(this.Attr());
            t = this.GetToken();
        }
        if (t.type() != TokenType.Oper || !"}".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("JSON\u5bf9\u8c61\u6784\u5efa\u9519\u8bef"));
        }
        return Expression.Json(children, this.pos);
    }

    private Expression JsonArray() {
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && "]".equals(t.value())) {
            return Expression.Constant(new JSONArray(), this.pos);
        }
        this.tokens.offer(t);
        List<Expression> ps = this.Params();
        t = this.GetToken();
        if (t.type() != TokenType.Oper || !"]".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("JSON\u96c6\u5408\u6784\u5efa\u9519\u8bef"));
        }
        return Expression.Array(ps, this.pos);
    }

    private Expression Attr() {
        String value;
        Token name = this.GetToken();
        if (name.type() == TokenType.Identy) {
            value = name.value().toString();
        } else if (name.type() == TokenType.Oper && ("$".equals(name.value()) || "\"".equals(name.value()))) {
            Expression expression = this.StringUnion().children.get(1);
            value = expression.value.toString();
        } else {
            throw new RuntimeException(this.GetExceptionMessage("JSON\u5bf9\u8c61\u7684key\u5fc5\u987b\u662f\u5c5e\u6027\u540d\u6216\u5b57\u7b26\u4e32"));
        }
        Token t = this.GetToken();
        if (t.type() != TokenType.Oper || !":".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("JSON\u6784\u5efa\u9519\u8bef"));
        }
        Expression exp = this.Exp();
        return Expression.Attr(value, exp, this.pos);
    }

    private Expression StringUnion() {
        Expression exp = Expression.Constant("", this.pos);
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && "{".equals(t.value()) || t.type() == TokenType.String) {
            if (t.type() == TokenType.String) {
                exp = Expression.Concat(exp, Expression.Constant(t.value(), this.pos), this.SOURCE, this.pos);
            } else {
                Expression objExp = this.Exp();
                t = this.GetToken();
                if (t.type() != TokenType.Oper || !"}".equals(t.value())) {
                    throw new RuntimeException(this.GetExceptionMessage("\u7f3a\u5c11'}'"));
                }
                exp = Expression.Concat(exp, objExp, this.SOURCE, this.pos);
            }
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return exp;
    }

    private Expression ObjectName(String objName) {
        return Expression.Identity(objName, this.pos);
    }

    private Expression ObjectPath(Expression inExp) {
        Expression objExp = this.ArrayIndex(inExp);
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && ".".equals(t.value())) {
            Token nameToken = this.GetToken();
            Token n = this.GetToken();
            if (n.type() == TokenType.Oper && "(".equals(n.value())) {
                String name = (String)nameToken.value();
                objExp = "each".equals(name) ? this.For(objExp) : this.MethodCall(name, objExp);
            } else {
                this.tokens.offer(n);
                String pi = (String)nameToken.value();
                objExp = Expression.Property(objExp, pi, this.pos);
                objExp = this.ArrayIndex(objExp);
            }
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return objExp;
    }

    private Expression ArrayIndex(Expression objExp) {
        Token n = this.GetToken();
        if (n.type() == TokenType.Oper && "[".equals(n.value())) {
            Expression exp = this.Exp();
            n = this.GetToken();
            if (n.type() != TokenType.Oper || !"]".equals(n.value())) {
                throw new RuntimeException(this.GetExceptionMessage("\u7f3a\u5c11']'"));
            }
            return Expression.ArrayIndex(objExp, exp, this.SOURCE, this.pos);
        }
        this.tokens.offer(n);
        return objExp;
    }

    private Expression For(Expression obj) {
        Expression exp = this.CommaExp();
        Token t = this.GetToken();
        if (t.type() != TokenType.Oper || !")".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("\u51fd\u6570\u8c03\u7528\u62ec\u53f7\u4e0d\u5339\u914d"));
        }
        return Expression.For(obj, exp, this.SOURCE, this.pos);
    }

    private Expression MethodCall(String name, Expression obj) {
        Token t = this.GetToken();
        if (t.type() == TokenType.Oper && ")".equals(t.value())) {
            ArrayList<Expression> ps = new ArrayList<Expression>();
            return Expression.Call(obj, name, ps, this.pos);
        }
        this.tokens.offer(t);
        List<Expression> ps = this.Params();
        t = this.GetToken();
        if (t.type() != TokenType.Oper || !")".equals(t.value())) {
            throw new RuntimeException(this.GetExceptionMessage("\u51fd\u6570\u8c03\u7528\u62ec\u53f7\u4e0d\u5339\u914d"));
        }
        return Expression.Call(obj, name, ps, this.pos);
    }

    private List<Expression> Params() {
        ArrayList<Expression> ps = new ArrayList<Expression>();
        String name = this.paramName();
        Expression exp = this.Exp();
        this.procParam(ps, exp, name);
        Token t = this.GetToken();
        while (t.type() == TokenType.Oper && ",".equals(t.value())) {
            name = this.paramName();
            exp = this.Exp();
            this.procParam(ps, exp, name);
            t = this.GetToken();
        }
        this.tokens.offer(t);
        return ps;
    }

    private String paramName() {
        Token t = this.GetToken();
        if (t.type() == TokenType.Identy) {
            Token t1 = this.GetToken();
            if (":".equals(t1.value())) {
                return t.value().toString();
            }
            this.tokens.offer(t);
            this.tokens.offer(t1);
            return "";
        }
        this.tokens.offer(t);
        return "";
    }

    private void procParam(List<Expression> ps, Expression exp, String name) {
        Delegate delegate = this.createDelegate(exp);
        if (delegate.containsKey("data")) {
            ps.add(Expression.Constant(delegate, this.pos));
        } else {
            ps.add(Expression.Param(exp, name, this.pos));
        }
    }

    private String GetExceptionMessage(String msg) {
        String result = this.SOURCE.substring(0, this.pos) + " <- " + this.SOURCE.substring(this.pos);
        return msg + "\uff1a\n" + result;
    }

    public Token GetToken() {
        if (!this.tokens.isEmpty()) {
            return this.tokens.poll();
        }
        int sPos = this.pos;
        boolean hasKeyword = this.pos < this.SOURCE_LENGTH;
        Character value = null;
        if (hasKeyword) {
            value = Character.valueOf(this.SOURCE.charAt(this.pos));
        }
        if (hasKeyword && value.charValue() == '{') {
            this.inStrings.push(this.inString);
            this.inString = false;
            String str = this.SOURCE.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (this.inString) {
            int startPos = this.pos;
            while (hasKeyword && value.charValue() != '{' && value.charValue() != '}' && value.charValue() != '$' && value.charValue() != '\"') {
                if (value.charValue() == '\\') {
                    char nextStrValue = this.SOURCE.charAt(this.pos + 1);
                    if (this.pos + 1 >= this.SOURCE_LENGTH || nextStrValue != '{' && nextStrValue != '}' && nextStrValue != '\"' && nextStrValue != '$' && nextStrValue != '\\') break;
                    ++this.pos;
                }
                ++this.pos;
                if (this.pos < this.SOURCE_LENGTH) {
                    value = Character.valueOf(this.SOURCE.charAt(this.pos));
                    continue;
                }
                hasKeyword = false;
            }
            if (!hasKeyword || value.charValue() != '{') {
                this.inString = this.inStrings.pop();
            }
            Token t = new Token(TokenType.String, this.SOURCE.substring(startPos, this.pos).replace("\\$", "$").replace("\\{", "{").replace("\\}", "}").replace("\\\"", "\"").replace("\\\\", "\\"), sPos);
            if (hasKeyword && (value.charValue() == '$' || value.charValue() == '\"')) {
                ++this.pos;
            }
            return t;
        }
        while (hasKeyword && (value.charValue() == ' ' || value.charValue() == '\n' || value.charValue() == '\t' || this.pos < this.SOURCE_LENGTH - 2 && value.charValue() == '/' && this.SOURCE.charAt(this.pos + 1) == '/')) {
            if (value.charValue() != ' ' && value.charValue() != '\n' && value.charValue() != '\t') {
                this.pos += 2;
                if (this.pos < this.SOURCE_LENGTH) {
                    value = Character.valueOf(this.SOURCE.charAt(this.pos));
                } else {
                    hasKeyword = false;
                }
                while (hasKeyword && value.charValue() != '\n') {
                    ++this.pos;
                    if (this.pos < this.SOURCE_LENGTH) {
                        value = Character.valueOf(this.SOURCE.charAt(this.pos));
                        continue;
                    }
                    hasKeyword = false;
                }
            }
            ++this.pos;
            if (this.pos < this.SOURCE_LENGTH) {
                value = Character.valueOf(this.SOURCE.charAt(this.pos));
                continue;
            }
            hasKeyword = false;
        }
        if (this.pos == this.SOURCE_LENGTH) {
            return new Token(TokenType.End, null, sPos);
        }
        assert (value != null);
        if (value.charValue() >= '0' && value.charValue() <= '9') {
            int oldPos = this.pos;
            while (hasKeyword && value.charValue() >= '0' && value.charValue() <= '9') {
                ++this.pos;
                if (this.pos < this.SOURCE_LENGTH) {
                    value = Character.valueOf(this.SOURCE.charAt(this.pos));
                    continue;
                }
                hasKeyword = false;
            }
            if (hasKeyword && value.charValue() == '.') {
                do {
                    ++this.pos;
                    if (this.pos < this.SOURCE_LENGTH) {
                        value = Character.valueOf(this.SOURCE.charAt(this.pos));
                        continue;
                    }
                    hasKeyword = false;
                } while (hasKeyword && value.charValue() >= '0' && value.charValue() <= '9');
                String str = this.SOURCE.substring(oldPos, this.pos);
                return new Token(TokenType.Double, new BigDecimal(str), sPos);
            }
            String str = this.SOURCE.substring(oldPos, this.pos);
            return new Token(TokenType.Int, Integer.parseInt(str), sPos);
        }
        if (value.charValue() >= 'a' && value.charValue() <= 'z' || value.charValue() >= 'A' && value.charValue() <= 'Z' || value.charValue() == '_' || Character.UnicodeScript.of(value.charValue()) == Character.UnicodeScript.HAN) {
            String str;
            int oldPos = this.pos;
            while (hasKeyword && (value.charValue() >= 'a' && value.charValue() <= 'z' || value.charValue() >= 'A' && value.charValue() <= 'Z' || value.charValue() >= '0' && value.charValue() <= '9' || value.charValue() == '_' || Character.UnicodeScript.of(value.charValue()) == Character.UnicodeScript.HAN)) {
                ++this.pos;
                if (this.pos < this.SOURCE_LENGTH) {
                    value = Character.valueOf(this.SOURCE.charAt(this.pos));
                    continue;
                }
                hasKeyword = false;
            }
            return switch (str = this.SOURCE.substring(oldPos, this.pos)) {
                case "false", "true" -> new Token(TokenType.Bool, Boolean.parseBoolean(str), sPos);
                case "null" -> new Token(TokenType.Null, null, sPos);
                default -> new Token(TokenType.Identy, str, sPos);
            };
        }
        if (value.charValue() == '&' && this.SOURCE.charAt(this.pos + 1) == '&' || value.charValue() == '|' && this.SOURCE.charAt(this.pos + 1) == '|') {
            String str = this.SOURCE.substring(this.pos, this.pos + 2);
            this.pos += 2;
            return new Token(TokenType.Oper, str, sPos);
        }
        if (value.charValue() == '+' || value.charValue() == '-' || value.charValue() == '*' || value.charValue() == '/' || value.charValue() == '%' || value.charValue() == '>' || value.charValue() == '<' || value.charValue() == '!') {
            String str;
            if (this.SOURCE.charAt(this.pos + 1) == '=') {
                str = this.SOURCE.substring(this.pos, this.pos + 2);
                this.pos += 2;
            } else {
                str = this.SOURCE.substring(this.pos, this.pos + 1);
                ++this.pos;
            }
            return new Token(TokenType.Oper, str, sPos);
        }
        if (value.charValue() == '=') {
            String str;
            if (this.SOURCE.charAt(this.pos + 1) == '=' || this.SOURCE.charAt(this.pos + 1) == '>') {
                str = this.SOURCE.substring(this.pos, this.pos + 2);
                this.pos += 2;
            } else {
                str = this.SOURCE.substring(this.pos, this.pos + 1);
                ++this.pos;
            }
            return new Token(TokenType.Oper, str, sPos);
        }
        if (value.charValue() == '(' || value.charValue() == ')' || value.charValue() == ',' || value.charValue() == ';' || value.charValue() == '.' || value.charValue() == ':' || value.charValue() == '@' || value.charValue() == '$' || value.charValue() == '\"' || value.charValue() == '{' || value.charValue() == '}' || value.charValue() == '[' || value.charValue() == ']') {
            if (value.charValue() == '$' || value.charValue() == '\"') {
                this.inStrings.push(false);
                this.inString = true;
            } else if (!(value.charValue() != '{' && value.charValue() != '}' || this.inStrings.isEmpty())) {
                if (value.charValue() == '{') {
                    this.inStrings.push(false);
                    this.inString = false;
                } else {
                    this.inString = this.inStrings.pop();
                }
            }
            String str = this.SOURCE.substring(this.pos, this.pos + 1);
            ++this.pos;
            return new Token(TokenType.Oper, str, sPos);
        }
        throw new RuntimeException(this.GetExceptionMessage("\u65e0\u6548\u5355\u8bcd\uff1a'" + value + "'"));
    }
}

