/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.report.core;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.expression.report.core.Block;
import com.af.v4.system.common.expression.report.core.Cell;
import com.af.v4.system.common.expression.report.core.Ret;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Element;
import org.json.JSONArray;

public class BodyBlock
extends Block {
    public final String headExpression;
    public final String leftExpression;
    public Delegate headDelegate;
    public Delegate leftDelegate;
    public String leftName;
    public String headName;
    public Object head;
    public Object left;

    public BodyBlock(Element ele) {
        super(ele);
        this.headExpression = ele.attributeValue("headexpression");
        this.leftExpression = ele.attributeValue("leftexpression");
        this.leftName = ele.attributeValue("leftname");
        this.headName = ele.attributeValue("headname");
        for (Element obj : ele.elements("bodyblock")) {
            this.cells.add(new BodyBlock(obj));
        }
    }

    public BodyBlock(int row, int column, int rowSpan, int columnSpan, String headExpression, String leftExpression) {
        super(row, column, rowSpan, columnSpan, null);
        this.headExpression = headExpression;
        this.leftExpression = leftExpression;
    }

    public void setRowColumn(int row, int column) {
        for (Cell cell : this.cells) {
            cell.row += row;
            cell.column += column;
            if (!(cell instanceof BodyBlock)) continue;
            BodyBlock block = (BodyBlock)cell;
            block.setRowColumn(row, column);
        }
    }

    @Override
    public void compile() {
        Program prog;
        super.compile();
        if (this.headExpression != null && !this.headExpression.trim().isEmpty()) {
            prog = new Program(this.headExpression);
            this.headDelegate = prog.parse();
        }
        if (this.leftExpression != null && !this.leftExpression.trim().isEmpty()) {
            prog = new Program(this.leftExpression);
            this.leftDelegate = prog.parse();
        }
    }

    public Ret createCell(List<Cell> result) {
        this.cells.sort(Comparator.comparingInt(o -> o.row * 10000 + o.column));
        int copyRow = 0;
        int copyColumn = 0;
        int oldCopyRow = 0;
        Cell oldCell = (Cell)this.cells.get(0);
        for (Cell cell : this.cells) {
            if (cell.column <= oldCell.column) {
                copyColumn = 0;
                oldCopyRow = copyRow;
            } else {
                copyRow = oldCopyRow;
            }
            oldCell = cell;
            if (cell instanceof BodyBlock) {
                JSONArray headData;
                BodyBlock block = (BodyBlock)cell;
                if (block.headDelegate != null && block.leftDelegate != null) {
                    int i = 0;
                    headData = this.getHeadArray(block);
                    JSONArray leftData = this.getLeftArray(block);
                    for (Object leftItem : leftData) {
                        if (i != 0) {
                            copyRow += block.rowSpan;
                        }
                        int j = 0;
                        int cellCopyRow = 0;
                        copyColumn = 0;
                        for (Object headItem : headData) {
                            BodyBlock newBlock = block.clone();
                            if (j != 0) {
                                copyColumn += block.rowSpan;
                            }
                            newBlock.setRowColumn(copyRow, copyColumn);
                            ArrayList<Cell> cells = new ArrayList<Cell>();
                            newBlock.head = headItem;
                            newBlock.left = leftItem;
                            this.report.vars.put(newBlock.headName, headItem);
                            this.report.vars.put(newBlock.leftName, leftItem);
                            Ret ret = newBlock.createCell(cells);
                            cellCopyRow = ret.copyRow;
                            copyColumn += ret.copyColumn;
                            result.addAll(cells);
                            ++j;
                        }
                        copyRow += cellCopyRow;
                        ++i;
                    }
                    continue;
                }
                if (block.headDelegate != null) {
                    int i = 0;
                    headData = (JSONArray)block.headDelegate.invoke(block.report.vars);
                    int cellCopyRow = 0;
                    for (Object headItem : headData) {
                        if (i != 0) {
                            copyColumn += block.columnSpan;
                        }
                        BodyBlock newBlock = block.clone();
                        newBlock.setRowColumn(copyRow, copyColumn);
                        ArrayList<Cell> cells = new ArrayList<Cell>();
                        newBlock.head = headItem;
                        this.report.vars.put(newBlock.headName, headItem);
                        Ret ret = newBlock.createCell(cells);
                        cellCopyRow = ret.copyRow;
                        copyColumn += ret.copyColumn;
                        result.addAll(cells);
                        ++i;
                    }
                    copyRow += cellCopyRow;
                    continue;
                }
                if (block.leftDelegate != null) {
                    int i = 0;
                    JSONArray leftData = (JSONArray)block.leftDelegate.invoke(block.report.vars);
                    for (Object leftItem : leftData) {
                        if (i != 0) {
                            copyRow += block.rowSpan;
                        }
                        BodyBlock newBlock = block.clone();
                        newBlock.setRowColumn(copyRow, copyColumn);
                        ArrayList<Cell> cells = new ArrayList<Cell>();
                        newBlock.left = leftItem;
                        this.report.vars.put(newBlock.leftName, leftItem);
                        Ret ret = newBlock.createCell(cells);
                        copyRow += ret.copyRow;
                        copyColumn += ret.copyColumn;
                        result.addAll(cells);
                        ++i;
                    }
                    continue;
                }
                BodyBlock newBlock = block.clone();
                newBlock.setRowColumn(copyRow, copyColumn);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                Ret ret = newBlock.createCell(cells);
                copyRow += ret.copyRow;
                copyColumn += ret.copyColumn;
                result.addAll(cells);
                continue;
            }
            cell.row += copyRow;
            cell.column += copyColumn;
            cell.content = cell.invoke().toString();
            result.add(cell);
        }
        return new Ret(copyRow, copyColumn);
    }

    private JSONArray getHeadArray(BodyBlock block) {
        block.report.vars.put("head", this.head);
        block.report.vars.put("left", this.left);
        Object headObject = block.headDelegate.invoke(block.report.vars);
        if (headObject instanceof JSONArray) {
            return (JSONArray)headObject;
        }
        JSONArray result = new JSONArray();
        result.put(headObject);
        return result;
    }

    private JSONArray getLeftArray(BodyBlock block) {
        block.report.vars.put("head", this.head);
        block.report.vars.put("left", this.left);
        Object leftObject = block.leftDelegate.invoke(block.report.vars);
        if (leftObject instanceof JSONArray) {
            return (JSONArray)leftObject;
        }
        JSONArray result = new JSONArray();
        result.put(leftObject);
        return result;
    }

    @Override
    public BodyBlock clone() {
        BodyBlock result = new BodyBlock(this.row, this.column, this.rowSpan, this.columnSpan, this.headExpression, this.leftExpression);
        if (this.report != null) {
            result.report = this.report;
        }
        for (Cell cell : this.cells) {
            result.cells.add(cell.clone());
        }
        if (this.headDelegate != null) {
            result.headDelegate = this.headDelegate;
        }
        if (this.leftDelegate != null) {
            result.leftDelegate = this.leftDelegate;
        }
        if (this.headName != null) {
            result.headName = this.headName;
        }
        if (this.leftName != null) {
            result.leftName = this.leftName;
        }
        return result;
    }
}

