/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.core;

import com.af.v4.system.common.expression.core.Expression;
import com.af.v4.system.common.expression.exception.ReturnWayException;
import java.util.HashMap;
import java.util.Map;

public class Delegate {
    private final Expression exp;
    private final String source;
    private Map<String, Object> objectNames = new HashMap<String, Object>();

    public Delegate(Expression exp, String source) {
        this.exp = exp;
        this.source = source;
    }

    public Object invoke() {
        return this.invoke(new HashMap<String, Object>(8));
    }

    public Object invoke(Map<String, Object> params) {
        this.setObjectNames(params);
        this.putDelegate(this.exp);
        try {
            return this.exp.invoke();
        }
        catch (ReturnWayException returnWay) {
            return returnWay.getReturnObject();
        }
    }

    private void putDelegate(Expression parent) {
        for (Expression child : parent.children) {
            if (child == null) continue;
            if ("Try".equals(child.type.name())) {
                Expression[] exps = (Expression[])child.value;
                assert (exps != null);
                if (exps[0] != null) {
                    exps[0].setDelegate(this);
                    this.putDelegate(exps[0]);
                }
                if (exps[1] != null) {
                    exps[1].setDelegate(this);
                    this.putDelegate(exps[1]);
                }
            }
            child.setDelegate(this);
            this.putDelegate(child);
        }
    }

    public Expression getExp() {
        return this.exp;
    }

    public Map<String, Object> getObjectNames() {
        return this.objectNames;
    }

    public void setObjectNames(Map<String, Object> objectNames) {
        this.objectNames = objectNames;
    }

    public void put(String key, Object value) {
        this.objectNames.put(key, value);
    }

    public Object get(String key) {
        return this.objectNames.get(key);
    }

    public boolean containsKey(String key) {
        return this.objectNames.containsKey(key);
    }

    public String getSource() {
        return this.source;
    }
}

