/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.core;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.ExpressionType;
import com.af.v4.system.common.expression.enums.ValidateMode;
import com.af.v4.system.common.expression.exception.BreakWayException;
import com.af.v4.system.common.expression.exception.ContinueWayException;
import com.af.v4.system.common.expression.exception.ExpressionException;
import com.af.v4.system.common.expression.exception.ReturnWayException;
import com.af.v4.system.common.expression.util.MethodSignatureMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Expression {
    public final ExpressionType type;
    public final Object value;
    private final int pos;
    public List<Expression> children;
    private Delegate delegate;

    private Expression(ExpressionType type, int pos) {
        this.type = type;
        this.value = null;
        this.pos = pos;
        this.children = new ArrayList<Expression>();
    }

    private Expression(ExpressionType type, Object value, int pos) {
        this.type = type;
        this.value = value;
        this.pos = pos;
        this.children = new ArrayList<Expression>();
    }

    private Expression(ExpressionType type, int pos, List<Expression> expressions) {
        this.type = type;
        this.value = null;
        this.pos = pos;
        this.children = expressions;
    }

    private Expression(ExpressionType type, Object value, int pos, Expression expression) {
        this.type = type;
        this.value = value;
        this.pos = pos;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(expression);
        this.children = expressions;
    }

    public static Expression Constant(Object value, int pos) {
        return new Expression(ExpressionType.Constant, value, pos);
    }

    public static Expression Lambda(Expression lambdaExp, int pos) {
        return new Expression(ExpressionType.Lambda, lambdaExp, pos);
    }

    public static Expression Return(Object value, Expression objExp, int pos) {
        return new Expression(ExpressionType.Return, value, pos, objExp);
    }

    public static Expression Break(Object value, Expression objExp, int pos) {
        return new Expression(ExpressionType.Break, value, pos, objExp);
    }

    public static Expression Continue(Object value, Expression objExp, int pos) {
        return new Expression(ExpressionType.Continue, value, pos, objExp);
    }

    public static Expression Throw(Object value, Expression objExp, int pos) {
        return new Expression(ExpressionType.Throw, value, pos, objExp);
    }

    public static Expression Assert(Object value, Expression objExp, int pos) {
        return new Expression(ExpressionType.Assert, value, pos, objExp);
    }

    public static Expression Validate(Expression objExp, int pos) {
        return new Expression(ExpressionType.Validate, null, pos, objExp);
    }

    public static Expression Identy(Object value, int pos) {
        return new Expression(ExpressionType.Identy, value, pos);
    }

    public static Expression Json(List<Expression> attrs, int pos) {
        Expression result = new Expression(ExpressionType.Json, pos);
        result.children.addAll(attrs);
        return result;
    }

    public static Expression Comma(List<Expression> children, int pos) {
        Expression result = new Expression(ExpressionType.Comma, pos);
        result.children.addAll(children);
        return result;
    }

    public static Expression Call(Expression objExp, String name, List<Expression> params, int pos) {
        Expression result = new Expression(ExpressionType.Call, name, pos);
        result.children.add(objExp);
        result.children.addAll(params);
        return result;
    }

    public static Expression Array(List<Expression> params, int pos) {
        return new Expression(ExpressionType.Array, pos, params);
    }

    public static Expression Param(Expression exp, String value, int pos) {
        Expression result = new Expression(ExpressionType.Param, value, pos);
        result.children.add(exp);
        return result;
    }

    public static Expression Property(Expression objExp, String name, int pos) {
        Expression result = new Expression(ExpressionType.Property, name, pos);
        result.children.add(objExp);
        return result;
    }

    public static Expression Attr(String name, Expression value, int pos) {
        Expression result = new Expression(ExpressionType.Attr, name, pos);
        result.children.add(value);
        return result;
    }

    public static Expression Assign(Expression objExp, Expression exp, String name, int pos) {
        Expression result = new Expression(ExpressionType.Assign, name, pos);
        result.children.add(objExp);
        result.children.add(exp);
        return result;
    }

    public static Expression Try(Expression tryExp, Expression finallyExp, List<Expression> catches, int pos) {
        Expression[] tryFinally = new Expression[]{tryExp, finallyExp};
        Expression result = new Expression(ExpressionType.Try, tryFinally, pos);
        result.children = catches;
        return result;
    }

    public static Expression Catch(String className, String varName, Expression catches, int pos) {
        String[] catchParameter = new String[]{className, varName};
        Expression result = new Expression(ExpressionType.Catch, catchParameter, pos);
        result.children.add(catches);
        return result;
    }

    public static Expression Condition(Expression test, Expression ifTrue, Expression ifFalse, String source, int pos) {
        Expression result = new Expression(ExpressionType.Condition, source, pos);
        result.children.add(test);
        result.children.add(ifTrue);
        result.children.add(ifFalse);
        return result;
    }

    public static Expression Not(Expression exp, String source, int pos) {
        Expression result = new Expression(ExpressionType.Not, source, pos);
        result.children.add(exp);
        return result;
    }

    public static Expression And(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.And, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Or(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Or, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Equal(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Equal, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression NotEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.NotEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Add(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Add, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Subtract(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Subtract, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Multiply(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Multiply, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Divide(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Divide, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Modulo(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Modulo, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Concat(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Concat, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression ArrayIndex(Expression objExp, Expression indexExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.ArrayIndex, source, pos);
        result.children.add(objExp);
        result.children.add(indexExp);
        return result;
    }

    public static Expression For(Expression objExp, Expression forExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.For, source, pos);
        result.children.add(objExp);
        result.children.add(forExp);
        return result;
    }

    private static boolean isNumberC(String str) {
        if ("".equals(str)) {
            return false;
        }
        StringBuilder stringBuilder = Expression.deleteChar(str);
        int i = stringBuilder.length();
        while (--i >= 0) {
            char chr = stringBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    private static StringBuilder deleteChar(String str) {
        int flag;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(str);
        if (stringBuilder.charAt(0) == '+' || stringBuilder.charAt(0) == '-') {
            stringBuilder.deleteCharAt(0);
        }
        if ((flag = stringBuilder.indexOf(".")) != -1) {
            stringBuilder.deleteCharAt(flag);
        }
        return stringBuilder;
    }

    public String toString() {
        return this.toString(0);
    }

    private Object condition() {
        Expression condExp = this.children.get(0);
        Expression isTrue = this.children.get(1);
        Expression isFalse = this.children.get(2);
        Object obj = condExp.invoke();
        boolean cond = this.getBoolean(obj);
        if (cond) {
            return isTrue.invoke();
        }
        return isFalse.invoke();
    }

    private Object loop() {
        Expression objExp = this.children.get(0);
        Object obj = objExp.invoke();
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            Expression body = this.children.get(1);
            for (int i = 0; i < array.length(); ++i) {
                this.delegate.put("rowIndex", i);
                this.delegate.put("row", array.get(i));
                try {
                    body.invoke();
                    continue;
                }
                catch (BreakWayException breakWayException) {
                    break;
                }
                catch (ContinueWayException breakWayException) {
                    // empty catch block
                }
            }
        } else if (obj instanceof JSONObject || obj instanceof Map) {
            Map map;
            Expression body = this.children.get(1);
            if (obj instanceof JSONObject) {
                JSONObject object = (JSONObject)obj;
                map = object.toMap();
            } else if (obj instanceof Map) {
                Map object;
                map = object = (Map)obj;
            } else {
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u5faa\u73af\u5bf9\u8c61\u7c7b\u578b\uff1a" + String.valueOf(obj.getClass()));
            }
            for (Map.Entry entry : map.entrySet()) {
                this.delegate.put("rowKey", entry.getKey());
                this.delegate.put("row", entry.getValue());
                try {
                    body.invoke();
                }
                catch (BreakWayException breakWayException) {
                    break;
                }
                catch (ContinueWayException continueWayException) {
                }
            }
        } else {
            int length;
            block25: {
                int start = 0;
                try {
                    if (objExp.children.size() == 2) {
                        start = Integer.parseInt(objExp.children.get(0).invoke().toString());
                        length = Integer.parseInt(objExp.children.get(1).invoke().toString());
                        break block25;
                    }
                    if (obj instanceof Integer) {
                        length = (Integer)obj;
                        break block25;
                    }
                    throw new ServiceException("for\u5faa\u73af\u53ea\u63a5\u6536\u96c6\u5408\u5bf9\u8c61\uff0c\u6574\u6570\u6216\u4e24\u4e2a\u6574\u6570\u7684\u7ec4\u5408");
                }
                catch (Exception e) {
                    throw new ServiceException("for\u5faa\u73af\u53ea\u63a5\u6536\u96c6\u5408\u5bf9\u8c61\uff0c\u6574\u6570\u6216\u4e24\u4e2a\u6574\u6570\u7684\u7ec4\u5408");
                }
            }
            for (int i = start; i < length; ++i) {
                Expression body = this.children.get(1);
                this.delegate.put("row", i);
                try {
                    body.invoke();
                    continue;
                }
                catch (BreakWayException breakWayException) {
                    break;
                }
                catch (ContinueWayException continueWayException) {
                    // empty catch block
                }
            }
        }
        return obj;
    }

    private Object where() {
        JSONArray array;
        JSONArray result = new JSONArray();
        Expression objExp = this.children.getFirst();
        Object ret = objExp.invoke();
        if (ret instanceof JSONArray) {
            array = (JSONArray)ret;
        } else if (ret instanceof Collection) {
            Collection list = (Collection)ret;
            array = new JSONArray();
            for (Object value : list) {
                array.put(value);
            }
        } else {
            throw new ServiceException("where\u51fd\u6570\u53ea\u652f\u6301JSONArray, Collection");
        }
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            Object value2;
            Object value = array.get(i);
            this.delegate.put("row", value);
            Object params = body.invoke();
            if (params instanceof AbstractMap.SimpleEntry) {
                AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)params;
                value2 = entry.getValue();
            } else {
                value2 = params;
            }
            if (!value2.equals(true)) continue;
            result.put(value);
        }
        return result;
    }

    public String toString(int level) {
        StringBuilder result = new StringBuilder(this.space(level) + "type: " + String.valueOf((Object)this.type) + ", value: " + (this.value != null ? this.value.toString() : "null") + "[\n");
        for (Expression child : this.children) {
            result.append((String)(child != null ? child.toString(level + 1) : this.space(level + 1) + "null\n"));
        }
        result.append(this.space(level)).append("]\n");
        return result.toString();
    }

    private Object sum() {
        BigDecimal result = new BigDecimal("0");
        Expression objExp = this.children.get(0);
        JSONArray array = (JSONArray)objExp.invoke();
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            String decimal;
            Object value = array.get(i);
            this.delegate.put("row", value);
            Object params = body.invoke();
            if (params instanceof AbstractMap.SimpleEntry) {
                AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)params;
                decimal = entry.getValue().toString();
            } else {
                decimal = String.valueOf(params);
            }
            result = decimal == null ? result.add(new BigDecimal(0)) : result.add(new BigDecimal(decimal));
        }
        return result;
    }

    private Object convert(Object source) {
        if (source instanceof Double) {
            return new BigDecimal(source.toString());
        }
        if (source instanceof Byte || source instanceof Short || source instanceof Integer) {
            return Integer.parseInt(source.toString());
        }
        return source;
    }

    private boolean isEqual(Throwable e, String name) {
        for (Class<?> c = e.getClass(); c != null; c = c.getSuperclass()) {
            int index;
            String s = c.getName();
            String catchName = s.substring((index = s.lastIndexOf(46)) + 1);
            if (!catchName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private Object Json() {
        JSONObject result = new JSONObject();
        for (Expression child : this.children) {
            String name = child.value.toString();
            Object value = child.children.getFirst().invoke();
            result.put(name, value);
        }
        return result;
    }

    private Object array() {
        JSONArray result = new JSONArray();
        for (Expression child : this.children) {
            Object value = child.invoke();
            result.put(value);
        }
        return result;
    }

    private boolean getBoolean(Object obj) {
        boolean cond = obj instanceof Boolean ? (Boolean)obj : obj != null;
        return cond;
    }

    private Object assign() {
        Expression right = this.children.get(1);
        Object value = right.invoke();
        String name = (String)this.value;
        if (this.delegate.getLambdaOutProps().contains(name)) {
            throw new ServiceException("lambda \u8868\u8fbe\u5f0f\u4e2d\u4f7f\u7528\u7684\u5916\u5c42\u53c2\u6570[" + name + "]\u4e3a\u5e38\u91cf\uff0c\u4e0d\u5141\u8bb8\u663e\u6027\u6539\u53d8");
        }
        Expression left = this.children.getFirst();
        if (left == null) {
            this.delegate.put(name, value);
        } else {
            Object obj = left.invoke();
            if (obj instanceof JSONObject) {
                JSONObject json = (JSONObject)obj;
                json.put(name, value);
            } else {
                try {
                    Field field = obj.getClass().getField(name);
                    field.set(obj, value);
                    return value;
                }
                catch (Exception e) {
                    throw new ServiceException("\u5c5e\u6027\u8d4b\u503c\u9519\u8bef\uff1a" + name);
                }
            }
        }
        return value;
    }

    private Object property(String key) throws Exception {
        Object rObj;
        Expression objExp = this.children.getFirst();
        Object obj = objExp.invoke();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (!map.containsKey(key)) {
                return null;
            }
            rObj = map.get(key);
        } else if (obj instanceof JSONObject) {
            JSONObject json = (JSONObject)obj;
            if (!json.has(key)) {
                return null;
            }
            rObj = json.get(key);
        } else {
            Field field = obj.getClass().getField(key);
            rObj = field.get(obj);
        }
        return this.convert(rObj);
    }

    private Object property() throws Exception {
        return this.property(this.value.toString());
    }

    private Object arrayIndex() {
        Expression objExp = this.children.get(0);
        Expression indexExp = this.children.get(1);
        Object obj = objExp.invoke();
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            int index = Integer.parseInt(indexExp.invoke().toString());
            Object oRet = array.get(index);
            return this.convert(oRet);
        }
        if (obj.getClass().isArray()) {
            int index = Integer.parseInt(indexExp.invoke().toString());
            if (obj.getClass() == int[].class) {
                int[] array = (int[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == double[].class) {
                double[] array = (double[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == byte[].class) {
                byte[] array = (byte[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == boolean[].class) {
                boolean[] array = (boolean[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == long[].class) {
                long[] array = (long[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == short[].class) {
                short[] array = (short[])obj;
                return this.convert(array[index]);
            }
            if (obj.getClass() == float[].class) {
                float[] array = (float[])obj;
                return this.convert(Float.valueOf(array[index]));
            }
            if (obj.getClass() == char[].class) {
                char[] array = (char[])obj;
                return this.convert(Character.valueOf(array[index]));
            }
            Object[] array = (Object[])obj;
            return this.convert(array[index]);
        }
        try {
            String key = indexExp.invoke().toString();
            return this.property(key);
        }
        catch (Exception e) {
            throw new ExpressionException(this.delegate.getSource(), this.pos, e);
        }
    }

    private String space(int n) {
        return "    ".repeat(Math.max(0, n));
    }

    private Object returnBusiness() {
        Object value = this.children.getFirst().invoke();
        throw new ReturnWayException(value);
    }

    private Object throwException() {
        Object result = this.children.getFirst().invoke();
        if (result instanceof JSONObject) {
            JSONObject obj = (JSONObject)result;
            throw new ServiceException(obj.getString("msg"), Integer.valueOf(obj.getInt("status")));
        }
        if (result instanceof Exception) {
            Exception e = (Exception)result;
            if (result instanceof ServiceException) {
                ServiceException ex = (ServiceException)result;
                throw ex;
            }
            throw new ExpressionException(this.delegate.getSource(), this.pos, e);
        }
        if (result == null) {
            result = "\u672a\u5b9a\u4e49\u5f02\u5e38";
        }
        throw new ServiceException(result.toString(), Integer.valueOf(400));
    }

    private Object assertExp() {
        Expression expression = this.children.getFirst();
        Object result = expression.invoke();
        if (result instanceof Boolean) {
            Boolean yn = (Boolean)result;
            if (!yn.booleanValue()) {
                throw new ServiceException("\u65ad\u8a00\u6821\u9a8c\u5931\u8d25", Integer.valueOf(400));
            }
        } else {
            throw new ServiceException("assert\u4ec5\u63a5\u6536boolean\u7ed3\u679c");
        }
        return true;
    }

    private Object validateParams() {
        Object result = this.children.getFirst().invoke();
        if (!(result instanceof JSONObject)) {
            throw new ServiceException("validate\u4ec5\u63a5\u6536json\u683c\u5f0f\u7684\u5bf9\u8c61");
        }
        JSONObject validateJson = (JSONObject)result;
        JSONObject params = (JSONObject)this.delegate.get("data");
        this.validateMain("data", params, validateJson);
        return result;
    }

    private Delegate lambda() {
        return new Delegate((Expression)this.value, this.delegate.getSource(), this.delegate.getObjectNames());
    }

    private void validateMain(String validateItemKey, JSONObject params, JSONObject validateJson) {
        block4: for (String key : validateJson.keySet()) {
            JSONObject item = validateJson.getJSONObject(key);
            ValidateMode validateMode = ValidateMode.toType(item.optString("mode", ValidateMode.NORMAL.getValue()));
            switch (validateMode) {
                case NORMAL: {
                    boolean hasParam;
                    boolean bl = hasParam = params.has(key) && params.opt(key) != null && params.opt(key) != JSONObject.NULL;
                    if (!hasParam) {
                        if (item.optBoolean("required", false)) {
                            String message = item.optString("message", "\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c" + validateItemKey + ">>" + key + "\u4e0d\u80fd\u4e3a\u7a7a");
                            throw new ServiceException(message, Integer.valueOf(400));
                        }
                        if (item.has("default")) {
                            params.put(key, item.get("default"));
                        }
                    }
                    if (!item.has("items")) continue block4;
                    JSONObject itemsValidate = item.getJSONObject("items");
                    this.validateMain(validateItemKey + ">>" + key, params.getJSONObject(key), itemsValidate);
                    break;
                }
                case AT_LEAST_ONE: {
                    JSONArray fields = item.getJSONArray("fields");
                    boolean isValidate = false;
                    for (Object field : fields) {
                        String fieldName = field.toString();
                        boolean hasParam = params.has(fieldName) && params.get(fieldName) != null;
                        if (!hasParam) continue;
                        isValidate = true;
                        break;
                    }
                    if (isValidate) break;
                    String message = item.optString("message", "\u53c2\u6570\u6821\u9a8c\u5931\u8d25:\u53c2\u6570\u7ec4" + String.valueOf(fields) + "\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new ServiceException(message, Integer.valueOf(400));
                }
            }
        }
    }

    private Object Param() {
        return this.children.getFirst().invoke();
    }

    private Object Try() {
        Expression[] exps = (Expression[])this.value;
        Expression tryExp = exps[0];
        try {
            Object object = tryExp.invoke();
            return object;
        }
        catch (Exception ex) {
            Throwable e = ex.getCause();
            for (Expression exp : this.children) {
                String[] catchValues = (String[])exp.value;
                String typeName = catchValues[0];
                String varName = catchValues[1];
                if (!this.isEqual(e, typeName)) continue;
                List<Expression> catchExp = exp.children;
                this.delegate.put(varName, e);
                Object object = catchExp.getFirst().invoke();
                return object;
            }
            throw ex;
        }
        finally {
            Expression finallyExp;
            if (exps.length > 1 && (finallyExp = exps[1]) != null) {
                finallyExp.invoke();
            }
        }
    }

    public Object invoke() {
        try {
            switch (this.type) {
                case Or: {
                    Expression left = this.children.get(0);
                    boolean l = this.getBoolean(left.invoke());
                    if (l) {
                        return true;
                    }
                    Expression right = this.children.get(1);
                    return this.getBoolean(right.invoke());
                }
                case And: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    boolean l = this.getBoolean(left.invoke());
                    if (l) {
                        return this.getBoolean(right.invoke());
                    }
                    return false;
                }
                case Not: {
                    Expression left = this.children.getFirst();
                    boolean l = this.getBoolean(left.invoke());
                    return !l;
                }
                case Add: 
                case Subtract: 
                case Multiply: 
                case Divide: 
                case Modulo: {
                    return this.math();
                }
                case Concat: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    Object r = right.invoke();
                    if (l == null) {
                        l = "null";
                    }
                    if (r == null) {
                        r = "null";
                    }
                    return l.toString() + String.valueOf(r);
                }
                case Json: {
                    return this.Json();
                }
                case Array: {
                    return this.array();
                }
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: {
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    Object r = right.invoke();
                    if (l instanceof String && r instanceof String) {
                        int result = ((String)l).compareTo((String)r);
                        return this.compare(result);
                    }
                    BigDecimal dl = new BigDecimal(l.toString());
                    BigDecimal dr = new BigDecimal(r.toString());
                    int cr = dl.compareTo(dr);
                    return this.compare(cr);
                }
                case Equal: 
                case NotEqual: {
                    Object r;
                    Expression left = this.children.get(0);
                    Expression right = this.children.get(1);
                    Object l = left.invoke();
                    if (l == null) {
                        l = "null";
                    }
                    if ((r = right.invoke()) == null) {
                        r = "null";
                    }
                    boolean equals = l instanceof Number && r instanceof Number || (l instanceof Number || r instanceof Number) && Expression.isNumberC(l.toString()) && Expression.isNumberC(r.toString()) ? new BigDecimal(String.valueOf(l)).compareTo(new BigDecimal(String.valueOf(r))) == 0 : l.toString().equals(r.toString());
                    return switch (this.type) {
                        case ExpressionType.Equal -> equals;
                        case ExpressionType.NotEqual -> !equals;
                        default -> throw new ServiceException("\u672a\u77e5\u7c7b\u578b");
                    };
                }
                case Constant: {
                    if (this.value instanceof Double) {
                        return new BigDecimal(this.value.toString());
                    }
                    return this.value;
                }
                case Identy: {
                    String name = (String)this.value;
                    if (!this.delegate.containsKey(name)) {
                        return null;
                    }
                    return this.delegate.get(name);
                }
                case Condition: {
                    return this.condition();
                }
                case Property: {
                    return this.property();
                }
                case ArrayIndex: {
                    return this.arrayIndex();
                }
                case Call: {
                    return this.call();
                }
                case For: {
                    return this.loop();
                }
                case Assign: {
                    return this.assign();
                }
                case Comma: {
                    Object value = 0;
                    for (Expression child : this.children) {
                        value = child.invoke();
                    }
                    return value;
                }
                case Try: {
                    return this.Try();
                }
                case Param: {
                    return this.Param();
                }
                case Return: {
                    return this.returnBusiness();
                }
                case Throw: {
                    return this.throwException();
                }
                case Assert: {
                    return this.assertExp();
                }
                case Validate: {
                    return this.validateParams();
                }
                case Lambda: {
                    return this.lambda();
                }
                case Break: {
                    throw new BreakWayException();
                }
                case Continue: {
                    throw new ContinueWayException();
                }
            }
            throw new ServiceException("\u65e0\u6548\u64cd\u4f5c");
        }
        catch (BreakWayException | ContinueWayException | ExpressionException | ReturnWayException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionException(this.delegate.getSource(), this.pos, ex);
        }
    }

    private boolean compare(int result) {
        return switch (this.type) {
            case ExpressionType.GreaterThan -> {
                if (result > 0) {
                    yield true;
                }
                yield false;
            }
            case ExpressionType.GreaterThanOrEqual -> {
                if (result >= 0) {
                    yield true;
                }
                yield false;
            }
            case ExpressionType.LessThan -> {
                if (result < 0) {
                    yield true;
                }
                yield false;
            }
            case ExpressionType.LessThanOrEqual -> {
                if (result <= 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw new ServiceException("\u672a\u77e5\u7c7b\u578b");
        };
    }

    private Object math() {
        Expression left = this.children.get(0);
        Expression right = this.children.get(1);
        Object oLeft = left.invoke();
        Object oRight = right.invoke();
        if (oLeft instanceof BigDecimal || oRight instanceof BigDecimal || oLeft.toString().contains(".") || oRight.toString().contains(".")) {
            BigDecimal l = new BigDecimal(oLeft.toString());
            BigDecimal r = new BigDecimal(oRight.toString());
            return switch (this.type) {
                case ExpressionType.Add -> l.add(r);
                case ExpressionType.Subtract -> l.subtract(r);
                case ExpressionType.Multiply -> l.multiply(r);
                case ExpressionType.Divide -> l.divide(r, 4, RoundingMode.DOWN);
                case ExpressionType.Modulo -> new BigDecimal(String.valueOf(l.intValue() % r.intValue()));
                default -> throw new ServiceException("\u672a\u77e5\u7c7b\u578b");
            };
        }
        int l = Integer.parseInt(left.invoke().toString());
        int r = Integer.parseInt(right.invoke().toString());
        return switch (this.type) {
            case ExpressionType.Add -> l + r;
            case ExpressionType.Subtract -> l - r;
            case ExpressionType.Multiply -> l * r;
            case ExpressionType.Divide -> l / r;
            case ExpressionType.Modulo -> l % r;
            default -> throw new ServiceException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
        };
    }

    private Object call() throws Exception {
        String name = (String)this.value;
        if ("where".equals(name)) {
            return this.where();
        }
        if ("sum".equals(name)) {
            return this.sum();
        }
        Expression objExp = this.children.getFirst();
        Object obj = objExp.invoke();
        if (obj == null) {
            throw new ServiceException("\u5bf9\u8c61[" + String.valueOf(objExp.value) + "]\u4e3anull");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 1; i < this.children.size(); ++i) {
            Expression paramExp = this.children.get(i);
            params.add(paramExp.invoke());
        }
        if ("runExpression".equals(name)) {
            String params1 = (String)params.getFirst();
            params.set(0, params1.replace('\'', '$'));
            params.add(this.delegate.getObjectNames());
        }
        Object[] types = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            types[i] = param == null ? null : param.getClass();
        }
        Class<?> c = obj.getClass();
        Method method = MethodSignatureMatcher.getMatchingMethod(c, name, types);
        if (method == null) {
            StringBuilder error = new StringBuilder("\u627e\u4e0d\u5230\u65b9\u6cd5:" + c.getName() + "." + name + "(");
            for (Object t : types) {
                if (t != null) {
                    error.append(t).append(",");
                    continue;
                }
                error.append("null,");
            }
            error.append(")");
            throw new ServiceException(error.toString());
        }
        Object oCall = method.invoke(obj, params.toArray());
        return this.convert(oCall);
    }

    public void setDelegate(Delegate delegate) {
        this.delegate = delegate;
    }
}

