/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.report.core;

import com.af.v4.system.common.expression.report.core.Cell;
import com.af.v4.system.common.expression.report.core.ReportBlock;
import com.af.v4.system.common.expression.report.core.Sql;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;

public class Report {
    public List<Sql> sqls = new ArrayList<Sql>();
    public List<Cell> cells = new ArrayList<Cell>();
    public Map<String, Object> vars = new HashMap<String, Object>();

    public Report(String source, JSONObject vars) {
        this.load(source);
        this.vars = vars.toMap();
    }

    public String render() {
        this.compile();
        for (Cell cell : this.cells) {
            cell.setReport(this);
        }
        List<Cell> result = this.createCells();
        Document doc = DocumentHelper.createDocument();
        Element table = this.layout(doc, result);
        return table.asXML();
    }

    private void load(String source) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((Reader)new StringReader(source));
            Element root = document.getRootElement();
            for (Element obj : root.elements("sql")) {
                this.sqls.add(new Sql(obj));
            }
            for (Element obj : root.elements("cell")) {
                this.cells.add(new Cell(obj));
            }
            for (Element obj : root.elements("reportblock")) {
                this.cells.add(new ReportBlock(obj));
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void compile() {
        for (Cell cell : this.cells) {
            cell.compile();
        }
    }

    public List<Cell> createCells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        this.cells.sort(Comparator.comparingInt(o -> o.row * 10000 + o.column));
        int copyRow = 0;
        for (Cell cell : this.cells) {
            if (cell instanceof ReportBlock) {
                ReportBlock block = (ReportBlock)cell;
                block.setRow(copyRow);
                copyRow += block.createCell(result);
                continue;
            }
            if (!"false".equals(cell.isDown)) {
                cell.row += copyRow;
            }
            cell.content = cell.invoke().toString();
            result.add(cell);
        }
        return result;
    }

    public Element layout(Document doc, List<Cell> cells) {
        Element eTable = doc.addElement("table");
        eTable.addAttribute("class", "tableprint");
        cells.sort(Comparator.comparingInt(o -> o.row * 10000 + o.column));
        int currentRow = -1;
        Element eTr = null;
        for (Cell cell : cells) {
            if (cell.row != currentRow) {
                eTr = eTable.addElement("tr");
                currentRow = cell.row;
            }
            assert (eTr != null);
            Element eTd = eTr.addElement("td");
            if (cell.css != null && !cell.css.isEmpty()) {
                eTd.addAttribute("class", cell.css);
            }
            if (cell.width != null && !cell.width.isEmpty()) {
                eTd.addAttribute("width", cell.width);
            }
            if (cell.height != null && !cell.height.isEmpty()) {
                eTd.addAttribute("height", cell.height);
            }
            if (cell.columnSpan > 1) {
                eTd.addAttribute("colspan", "" + cell.columnSpan);
            }
            if (cell.rowSpan > 1) {
                eTd.addAttribute("rowspan", "" + cell.rowSpan);
            }
            if (cell.type != null && cell.type.equals("html")) {
                SAXReader reader = new SAXReader();
                try {
                    Document document = reader.read((Reader)new StringReader(cell.content));
                    Element root = document.getRootElement();
                    eTd.add(root);
                    continue;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            eTd.addText(cell.content);
        }
        return eTable;
    }
}

