package com.af.v4.system.common.expression.report.core;

import org.dom4j.Element;

import java.util.List;

// 一个含多级表头，多级表体的报表块
public class ReportBlock extends Block {
    // 表头块
    public HeadBlock headBlock;

    // 表左块
    public LeftBlock leftBlock;

    // 表体块
    public BodyBlock bodyBlock;

    public ReportBlock(Element ele) {
        super(ele);
        // 取headblock
        Element eHead = ele.element("headblock");
        this.headBlock = new HeadBlock(eHead);

        // 取leftblock
        Element eLeft = ele.element("leftblock");
        this.leftBlock = new LeftBlock(eLeft);

        // 取bodyblock
        Element eBody = ele.element("bodyblock");
        this.bodyBlock = new BodyBlock(eBody);
    }

    public ReportBlock(int row, int column, int rowSpan, int columnSpan, HeadBlock headBlock, LeftBlock leftBlock, BodyBlock bodyBlock) {
        super(row, column, rowSpan, columnSpan, "");
        this.headBlock = headBlock;
        this.leftBlock = leftBlock;
        this.bodyBlock = bodyBlock;
    }

    // 重置块的起始行
    public void setRow(int row) {
        // 对块中的每一个单元格，更改列号，如果是块，要递归做
        for (Cell cell : cells) {
            cell.row = cell.row + row;
        }
        // 设置各block的行
        if (this.headBlock != null) {
            this.headBlock.setRow(row);
        }
        if (this.leftBlock != null) {
            this.leftBlock.setRow(row);
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.setRowColumn(row, 0);
        }
    }

    @Override
    public void compile() {
        super.compile();
        if (this.headBlock != null) {
            this.headBlock.compile();
        }
        if (this.leftBlock != null) {
            this.leftBlock.compile();
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.compile();
        }
    }

    @Override
    public void setReport(Report report) {
        super.setReport(report);
        if (this.headBlock != null) {
            this.headBlock.setReport(report);
        }
        if (this.leftBlock != null) {
            this.leftBlock.setReport(report);
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.setReport(report);
        }
    }

    // 创建单元格，返回复制了多少行，复合表格不支持纵向复合。
    public int createCell(List<Cell> result) {
        this.headBlock.createCell(result);
        int copyRow = this.leftBlock.createCell(result);
        Ret ret = this.bodyBlock.createCell(result);

        // 添加其它占位单元格
        for (Cell cell : cells) {
            // 纯cell直接添加
            if (!(cell instanceof Block)) {
                result.add(cell.clone());
            }
        }

        return copyRow + ret.copyRow;
    }
}
