package com.af.v4.system.common.excel.core;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

import java.util.List;

public class CustomCellStyleHandler extends HorizontalCellStyleStrategy {


    private final List<String> customHeader;

    public static final WriteCellStyle COMMON_HEADER_STYLE;
    public static final WriteCellStyle COMMON_CONTENT_STYLE;
    public static final WriteFont COMMON_HEADER_FONT;

    static {
        COMMON_HEADER_STYLE = new WriteCellStyle();
        COMMON_HEADER_STYLE.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
        COMMON_HEADER_STYLE.setVerticalAlignment(VerticalAlignment.CENTER);

        COMMON_CONTENT_STYLE = new WriteCellStyle();
        COMMON_CONTENT_STYLE.setHorizontalAlignment(HorizontalAlignment.LEFT);

        COMMON_HEADER_FONT = new WriteFont();
        COMMON_HEADER_FONT.setFontName("宋体");
        COMMON_HEADER_FONT.setFontHeightInPoints((short) 12);
        COMMON_HEADER_FONT.setBold(true);
    }


    public CustomCellStyleHandler(List<String> customHeader) {
        super(COMMON_HEADER_STYLE, COMMON_CONTENT_STYLE);
        this.customHeader = customHeader;
    }

    @Override
    protected void setHeadCellStyle(CellWriteHandlerContext context) {
        WriteCellStyle headWriteCellStyle = getHeadWriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        // 设置描述列表样式
        if (context.getRowIndex() < customHeader.size()) {
            // 字体大小
//            headWriteFont.setFontHeightInPoints((short) 12);
            // 合并
//            WriteFont.merge(COMMON_HEADER_FONT, headWriteFont);
//            headWriteCellStyle.setWriteFont(headWriteFont);
            // 描述列表向左
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else {
            // 字体大小
//            headWriteFont.setFontHeightInPoints((short) 12);
            // 合并
//            WriteFont.merge(COMMON_HEADER_FONT, headWriteFont);
            // 字体大小
//            headWriteCellStyle.setWriteFont(headWriteFont);
            // 表头居中
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        }

        if (stopProcessing(context)) {
            return;
        }

        WriteCellData<?> cellData = context.getFirstCellData();
        WriteCellStyle.merge(headWriteCellStyle, cellData.getOrCreateStyle());
    }
}
