/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.excel.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.NumberUtil;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.excel.constant.ExcelConstant;
import com.af.v4.system.common.excel.convert.BaseDateConverter;
import com.af.v4.system.common.excel.convert.CharacterConverter;
import com.af.v4.system.common.excel.convert.ExcelBigNumberConvert;
import com.af.v4.system.common.excel.convert.NumberToDateConverter;
import com.af.v4.system.common.excel.convert.StringConverter;
import com.af.v4.system.common.excel.core.CustomCellStyleHandler;
import com.af.v4.system.common.excel.core.DefaultExcelListener;
import com.af.v4.system.common.excel.core.ExcelListener;
import com.af.v4.system.common.excel.core.ExcelResult;
import com.af.v4.system.common.excel.core.ExportStaffProgressWriteHandler;
import com.af.v4.system.common.excel.template.ExcelTemplate_Grey;
import com.af.v4.system.common.excel.utils.FileUtil;
import com.af.v4.system.common.file.utils.FilePathUtil;
import com.af.v4.system.common.liuli.dict.service.LiuLiDictService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.row.SimpleRowHeightStyleStrategy;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class ExcelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelService.class);
    private static int pageMaxSize;
    private static ObjectFactory<ExportStaffProgressWriteHandler> exportStaffProgressWriteHandlerObjectFactory;
    private final ResourceLoader resourceLoader;
    private final FilePathUtil filePathUtil;

    public ExcelService(ResourceLoader resourceLoader, ObjectFactory<ExportStaffProgressWriteHandler> exportStaffProgressWriteHandlerObjectFactory, FilePathUtil filePathUtil) {
        this.resourceLoader = resourceLoader;
        ExcelService.exportStaffProgressWriteHandlerObjectFactory = exportStaffProgressWriteHandlerObjectFactory;
        this.filePathUtil = filePathUtil;
    }

    private static String getExcelType(int dataSize, int headSize) {
        String type;
        if (dataSize < 65530 && headSize < 256) {
            type = "XLS";
            pageMaxSize = 65530;
        } else {
            type = "XLSX";
            pageMaxSize = 1048570;
        }
        return type;
    }

    private static void branchSheet(String sheetName, ExcelWriter writer, List<List<String>> head, List<List<Object>> writeData, List<Object> fillData) {
        int start = 0;
        int dataSize = writeData == null ? fillData.size() : writeData.size();
        int sheetCount = dataSize % pageMaxSize == 0 ? dataSize / pageMaxSize : dataSize / pageMaxSize + 1;
        try {
            for (int pageNo = 0; pageNo < sheetCount; ++pageNo) {
                int end = (pageNo + 1) * pageMaxSize;
                if (end > dataSize) {
                    end = dataSize;
                }
                if (head != null) {
                    writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)pageNo, (String)(sheetName + pageNo)).head(head)).build();
                    if (writeData != null) {
                        writer.write(writeData.subList(start, end), writeSheet);
                    }
                } else {
                    writeSheet = EasyExcel.writerSheet((Integer)pageNo, (String)(sheetName + pageNo)).build();
                    writer.fill(fillData.subList(start, end), writeSheet);
                }
                start = end;
            }
        }
        catch (Exception e) {
            throw new ExcelGenerateException("\u5206\u9875\u5bfc\u51fa\u9519\u8bef\uff01\u5982\u662f\u6a21\u677f\u586b\u5145\u5bfc\u51fa\u8bf7\u786e\u5b9a\u662f\u5426\u6839\u636e\u6587\u4ef6\u9650\u5236\u5927\u5c0f\u63d0\u524d\u8bbe\u7f6e\u6a21\u677f\u9875\u6570\uff01", (Throwable)e);
        }
    }

    private static void resetResponse(String sheetName, String type, HttpServletResponse response) {
        String filename = ExcelService.encodingFilename(sheetName, type);
        FileUtil.setAttachmentResponseHeader(response, filename);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
    }

    public static String encodingFilename(String filename, String type) {
        if (type.equals("XLSX")) {
            return filename + "_" + IdUtil.fastSimpleUUID() + ".xlsx";
        }
        if (type.equals("XLS")) {
            return filename + "_" + IdUtil.fastSimpleUUID() + ".xls";
        }
        return filename + "_" + IdUtil.fastSimpleUUID() + ".cvs";
    }

    public static <T> List<T> importExcel(InputStream is, JSONArray headList) {
        return ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)is).registerConverter((Converter)new NumberToDateConverter())).head(ExcelService.assembleHead(headList))).autoCloseStream(Boolean.valueOf(false)).sheet().doReadSync();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Map<String, Object> headMap, boolean isValidate) {
        DefaultExcelListener listener = new DefaultExcelListener(isValidate, headMap);
        ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, listener).sheet().registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).registerConverter((Converter)new BaseDateConverter.LocalDateConverter())).registerConverter((Converter)new BaseDateConverter.LocalTimeConverter())).doRead();
        return listener.getExcelResult();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, ExcelListener<T> listener) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, listener).sheet().registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).doRead();
        return listener.getExcelResult();
    }

    protected static ExcelWriterBuilder write(String type, OutputStream os, ExcelConstant constants, boolean hasStyle, List<Object> style, boolean hasAppoint, List<Object> appointCell) {
        return ExcelService.write(type, os, constants, hasStyle, style, hasAppoint, appointCell, null);
    }

    protected static ExcelWriterBuilder write(String type, OutputStream os, ExcelConstant constants, boolean hasStyle, List<Object> style, boolean hasAppoint, List<Object> appointCell, List<String> customHeadMsg) {
        return (ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).autoCloseStream(Boolean.valueOf(false)).useDefaultStyle(Boolean.valueOf(false))).registerConverter((Converter)new ExcelBigNumberConvert())).registerConverter((Converter)new StringConverter())).registerConverter((Converter)new CharacterConverter())).registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).excelType(ExcelTypeEnum.valueOf((String)type)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)new CustomCellStyleHandler(customHeadMsg))).registerWriteHandler((WriteHandler)new SimpleRowHeightStyleStrategy(Short.valueOf((short)20), Short.valueOf((short)20)));
    }

    public static void exportExcel(List<Object> dataList, JSONArray headList, String sheetName, HttpServletResponse response) {
        ExcelService.exportExcel(dataList, headList, sheetName, null, true, new ExcelTemplate_Grey(), false, null, response);
    }

    public static void exportExcel(List<Object> dataList, JSONArray headList, String sheetName, List<Object> style, boolean hasStyle, ExcelConstant constant, boolean hasAppoint, List<Object> appointCell, HttpServletResponse response) {
        try {
            String type = ExcelService.getExcelType(dataList.size(), headList.length());
            ExcelService.resetResponse(sheetName, type, response);
            ServletOutputStream os = response.getOutputStream();
            List<List<String>> head = ExcelService.assembleHead(headList);
            List<List<Object>> data = ExcelService.assembleDataWithSlot(dataList, new ArrayList<Map<String, String>>());
            int dataSize = dataList.size();
            if (dataSize > pageMaxSize) {
                ExcelWriter writer = ExcelService.write(type, (OutputStream)os, constant, hasStyle, style, hasAppoint, appointCell).build();
                ExcelService.branchSheet(sheetName, writer, head, data, null);
                writer.finish();
            } else {
                ExcelWriterBuilder builder = ExcelService.write(type, (OutputStream)os, constant, hasStyle, style, hasAppoint, appointCell);
                ((ExcelWriterSheetBuilder)builder.sheet(sheetName).head(head)).doWrite(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38\uff01", e);
        }
    }

    public static void exportTemplate(List<Object> data, String fileName, String templatePath, HttpServletResponse response) {
        try {
            if (CollUtil.isEmpty(data)) {
                throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
            }
            String type = ExcelService.getExcelType(1, 1);
            ExcelService.resetResponse(fileName, type, response);
            ServletOutputStream os = response.getOutputStream();
            ClassPathResource templateResource = new ClassPathResource(templatePath);
            ExcelWriter writer = ExcelService.write(type, (OutputStream)os, null, false, null, false, null).withTemplate(templateResource.getStream()).build();
            int dataSize = data.size();
            if (dataSize > pageMaxSize) {
                ExcelService.branchSheet(fileName, writer, null, null, data);
            } else {
                WriteSheet writeSheet = EasyExcel.writerSheet().build();
                writer.fill(data, writeSheet);
            }
            writer.finish();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38", e);
        }
    }

    protected static List<List<String>> assembleHead(JSONArray headList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        headList.forEach(str -> {
            ArrayList<String> heads = new ArrayList<String>();
            heads.add(str.toString());
            list.add(heads);
        });
        return list;
    }

    private static List<List<String>> assembleHead(JSONArray headList, List<String> customHeadMsg) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ArrayList<String> finalCustomHeadMsg = customHeadMsg != null ? new ArrayList<String>(customHeadMsg) : new ArrayList();
        headList.forEach(str -> {
            ArrayList<String> heads = new ArrayList<String>(finalCustomHeadMsg);
            heads.add(str.toString());
            list.add(heads);
        });
        return list;
    }

    protected static List<List<Object>> assembleDataWithSlot(List<Object> dataList, List<Map<String, String>> exportFieldsSlot) {
        boolean isDev;
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>(dataList.size());
        LiuLiDictService liuLiDictService = (LiuLiDictService)SpringUtils.getBean(LiuLiDictService.class);
        ApplicationUtils applicationUtils = (ApplicationUtils)SpringUtils.getBean(ApplicationUtils.class);
        boolean bl = isDev = applicationUtils.getEnvType() != EnvType.PROD;
        if (isDev) {
            LOGGER.warn("\u5f00\u53d1\u6a21\u5f0f\u5bfc\u51fa\u4e0d\u83b7\u53d6\u5b57\u5178\u952e");
        }
        dataList.forEach(item -> {
            ArrayList data = new ArrayList();
            ArrayList valuesList = new ArrayList(((Map)item).values());
            IntStream.range(0, valuesList.size()).forEach(index -> {
                Map slot;
                Object value = valuesList.get(index);
                value = value == JSONObject.NULL ? "--" : Objects.requireNonNullElse(value, "--");
                Map map = slot = exportFieldsSlot.isEmpty() || exportFieldsSlot.size() <= index ? null : (Map)exportFieldsSlot.get(index);
                if (slot != null) {
                    value = switch ((String)slot.get("slotType")) {
                        case "fourDecimal" -> {
                            if (NumberUtil.isNumber((CharSequence)value.toString())) {
                                yield NumberUtil.round((double)NumberUtil.parseFloat((String)value.toString(), (Float)Float.valueOf(0.0f)).floatValue(), (int)4);
                            }
                            yield value;
                        }
                        case "towDecimal" -> {
                            if (NumberUtil.isNumber((CharSequence)value.toString())) {
                                yield NumberUtil.round((double)NumberUtil.parseFloat((String)value.toString(), (Float)Float.valueOf(0.0f)).floatValue(), (int)2);
                            }
                            yield value;
                        }
                        case "int" -> {
                            if (NumberUtil.isNumber((CharSequence)value.toString())) {
                                yield NumberUtil.parseInt((String)value.toString(), (Integer)0);
                            }
                            yield value;
                        }
                        case "badge" -> {
                            if (slot.get("slotKeyMap") != null && applicationUtils.getEnvType() == EnvType.PROD) {
                                yield liuLiDictService.getDictLabel((String)slot.get("slotKeyMap"), value.toString());
                            }
                            yield value;
                        }
                        default -> value;
                    };
                }
                data.add(value);
            });
            lists.add(data);
        });
        return lists;
    }

    private static List<List<Object>> assembleDataWithFields(List<Object> dataList, List<String> fields) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>(dataList.size());
        dataList.forEach(item -> {
            ArrayList data = new ArrayList();
            fields.forEach(field -> {
                Object v = ((Map)item).get(field);
                if (JSONObject.NULL == v) {
                    v = "--";
                }
                data.add(v);
            });
            lists.add(data);
        });
        return lists;
    }

    public static Map<String, Object> getTableHeaders(JSONArray jsonArray) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject data = jsonObject.getJSONObject("data");
            for (String key : data.keySet()) {
                headers.put(data.getString(key), key);
            }
        }
        return headers;
    }

    protected static ExcelWriterBuilder write(String type, OutputStream os, ExcelConstant constants, boolean hasStyle, List<Object> style, boolean hasAppoint, List<Object> appointCell, List<String> customHeadMsg, int dataSize, String taskName, String userId) {
        ExportStaffProgressWriteHandler exportStaffProgressWriteHandler = (ExportStaffProgressWriteHandler)exportStaffProgressWriteHandlerObjectFactory.getObject();
        exportStaffProgressWriteHandler.init(dataSize, taskName, userId);
        return (ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).autoCloseStream(Boolean.valueOf(false)).useDefaultStyle(Boolean.valueOf(false))).registerConverter((Converter)new ExcelBigNumberConvert())).registerConverter((Converter)new StringConverter())).registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).excelType(ExcelTypeEnum.valueOf((String)type)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)new CustomCellStyleHandler(customHeadMsg))).registerWriteHandler((WriteHandler)new SimpleRowHeightStyleStrategy(Short.valueOf((short)20), Short.valueOf((short)20)))).registerWriteHandler((WriteHandler)exportStaffProgressWriteHandler);
    }

    public static JSONArray mergeJsonData(JSONArray mappings, JSONArray baseArray) {
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < baseArray.length(); ++i) {
            JSONObject baseObject = baseArray.getJSONObject(i);
            JSONObject finalObject = new JSONObject();
            for (int j = 0; j < mappings.length(); ++j) {
                JSONObject mapping = mappings.getJSONObject(j);
                String tableName = mapping.getString("tablename");
                JSONObject mappedData = mapping.getJSONObject("data");
                JSONObject newObject = new JSONObject();
                for (String key : mappedData.keySet()) {
                    if (!baseObject.has(key)) continue;
                    newObject.put(key, baseObject.get(key));
                }
                finalObject.put(tableName, (Object)newObject);
            }
            resultArray.put((Object)finalObject);
        }
        return resultArray;
    }

    public String asyncExportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName, List<String> customHeadMsg, String taskName, String userId) {
        return this.asyncExportExcelToServer(dataList, headList, sheetName, null, false, null, false, null, customHeadMsg, taskName, userId, new ArrayList<Map<String, String>>());
    }

    public String asyncExportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName, List<String> customHeadMsg, String taskName, String userId, JSONObject queryParams) {
        return this.asyncExportExcelToServer(dataList, headList, sheetName, null, false, null, false, null, customHeadMsg, taskName, userId, this.getExportFieldsSlot(queryParams));
    }

    private String asyncExportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName, List<Object> style, boolean hasStyle, ExcelConstant constant, boolean hasAppoint, List<Object> appointCell, List<String> customHeadMsg, String taskName, String userId, List<Map<String, String>> exportFieldsSlot) {
        try {
            String type = ExcelService.getExcelType(dataList.size(), headList.length());
            sheetName = ExcelService.encodingFilename(sheetName, type);
            String filePath = this.getFilePath();
            String fileName = this.getFileName(sheetName);
            List<List<String>> head = ExcelService.assembleHead(headList, customHeadMsg);
            List<List<Object>> data = ExcelService.assembleDataWithSlot(dataList, exportFieldsSlot);
            int dataSize = dataList.size();
            try (FileOutputStream fos = new FileOutputStream(filePath + fileName);){
                if (dataSize > pageMaxSize) {
                    ExcelWriter writer = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell, customHeadMsg, dataSize, taskName, userId).build();
                    ExcelService.branchSheet("Sheet", writer, head, data, null);
                    writer.finish();
                } else {
                    ExcelWriterBuilder builder = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell, customHeadMsg, dataSize, taskName, userId);
                    ((ExcelWriterSheetBuilder)builder.sheet(sheetName).head(head)).doWrite(data);
                }
            }
            return this.filePathUtil.getFileDownloadUrlByServer("EXCEL", fileName);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaExcel\u5f02\u5e38\uff01", e);
        }
    }

    private String exportExcelToServer(List<Object> dataList, JSONArray headList, List<String> fields, String sheetName, List<Object> style, boolean hasStyle, ExcelConstant constant, boolean hasAppoint, List<Object> appointCell, List<String> customHeadMsg, List<Map<String, String>> exportFieldsSlot) {
        try {
            String type = ExcelService.getExcelType(dataList.size(), headList.length());
            sheetName = ExcelService.encodingFilename(sheetName, type);
            String filePath = this.getFilePath();
            String fileName = this.getFileName(sheetName);
            List<List<String>> head = ExcelService.assembleHead(headList, customHeadMsg);
            List<List<Object>> data = fields == null ? ExcelService.assembleDataWithSlot(dataList, exportFieldsSlot) : ExcelService.assembleDataWithFields(dataList, fields);
            int dataSize = dataList.size();
            try (FileOutputStream fos = new FileOutputStream(filePath + fileName);){
                if (dataSize > pageMaxSize) {
                    ExcelWriter writer = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell, customHeadMsg).build();
                    ExcelService.branchSheet("Sheet", writer, head, data, null);
                    writer.finish();
                } else {
                    ExcelWriterBuilder builder = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell, customHeadMsg);
                    ((ExcelWriterSheetBuilder)builder.sheet(sheetName).head(head)).doWrite(data);
                }
            }
            return this.filePathUtil.getFileDownloadUrlByServer("EXCEL", fileName);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaExcel\u5f02\u5e38\uff01", e);
        }
    }

    public String exportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName) {
        ArrayList<String> headerMsg = new ArrayList<String>();
        headerMsg.add("\u5bfc\u51fa\u65f6\u95f4\uff1a" + DateTools.getNow2());
        return this.exportExcelToServer(dataList, headList, null, sheetName, null, false, null, false, null, headerMsg, new ArrayList<Map<String, String>>());
    }

    public String exportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName, List<String> customHeadMsg, JSONObject queryParams) {
        return this.exportExcelToServer(dataList, headList, null, sheetName, null, false, null, false, null, customHeadMsg, this.getExportFieldsSlot(queryParams));
    }

    public String exportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName, List<String> customHeadMsg) {
        return this.exportExcelToServer(dataList, headList, null, sheetName, null, false, null, false, null, customHeadMsg, new ArrayList<Map<String, String>>());
    }

    public String exportExcelToServerByFieldList(List<Object> dataList, JSONArray fieldList, String sheetName) {
        JSONArray headList = new JSONArray();
        ArrayList<String> fields = new ArrayList<String>(fieldList.length());
        for (Object temp : fieldList) {
            fields.add(((String)temp).split(":")[0]);
            headList.put((Object)((String)temp).split(":")[1]);
        }
        return this.exportExcelToServer(dataList, headList, fields, sheetName, null, false, null, false, null, new ArrayList<String>(), new ArrayList<Map<String, String>>());
    }

    public JSONArray readExcelByV3Json(String filepath, String jsonName, Boolean isRemote) {
        filepath = filepath.replaceAll("\\\\", "/");
        filepath = filepath.replace("\\", "/");
        JSONArray result = new JSONArray();
        if (isRemote.booleanValue()) {
            return result;
        }
        try {
            Resource resource = this.resourceLoader.getResource("classpath:/impexp/imp/" + jsonName);
            byte[] bytes = Files.readAllBytes(Paths.get(resource.getURI()));
            JSONArray config = new JSONArray(new String(bytes, StandardCharsets.UTF_8));
            JSONArray basedata = new JSONArray(ExcelService.importExcel(new FileInputStream(filepath), ExcelService.getTableHeaders(config), false).getList());
            return ExcelService.mergeJsonData(config, basedata);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONArray readExcelByV3Json(String filepath, JSONArray config, Boolean isRemote) {
        filepath = filepath.replaceAll("\\\\", "/");
        filepath = filepath.replace("\\", "/");
        JSONArray result = new JSONArray();
        if (isRemote.booleanValue()) {
            return result;
        }
        try {
            JSONArray basedata = new JSONArray(ExcelService.importExcel(new FileInputStream(filepath), ExcelService.getTableHeaders(config), false).getList());
            return ExcelService.mergeJsonData(config, basedata);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFilePath() {
        String fullPath = this.filePathUtil.getFileFullPathByServer("EXCEL", "");
        File file = new File(fullPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return fullPath;
    }

    public String getFileName(String name) {
        return name == null ? String.valueOf(UUID.randomUUID()) + ".xlsx" : name;
    }

    public List<Map<String, String>> getExportFieldsSlot(JSONObject queryParams) {
        JSONArray chineseQueryColumnArray = queryParams.optJSONArray("chineseQueryColumnArray");
        JSONArray columnJson = queryParams.optJSONArray("columnJson");
        ArrayList<Map<String, String>> exportFieldsSlot = new ArrayList<Map<String, String>>();
        if (!chineseQueryColumnArray.isEmpty()) {
            for (int i = 0; i < chineseQueryColumnArray.length(); ++i) {
                for (int j = 0; j < columnJson.length(); ++j) {
                    if (!columnJson.getJSONObject(j).getString("title").equals(chineseQueryColumnArray.getString(i))) continue;
                    HashMap<String, String> slot = new HashMap<String, String>();
                    slot.put("slotType", columnJson.getJSONObject(j).optString("slotType"));
                    if (columnJson.getJSONObject(j).has("slotKeyMap")) {
                        slot.put("slotKeyMap", columnJson.getJSONObject(j).optString("slotKeyMap"));
                    }
                    exportFieldsSlot.add(slot);
                }
            }
        }
        return exportFieldsSlot;
    }
}

