/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.excel.core;

import cn.hutool.core.util.StrUtil;
import com.af.v4.system.common.excel.core.DefaultExcelResult;
import com.af.v4.system.common.excel.core.ExcelListener;
import com.af.v4.system.common.excel.core.ExcelResult;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.exception.ExcelDataConvertException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExcelListener<T>
extends AnalysisEventListener<T>
implements ExcelListener<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultExcelListener.class);
    private final Map<String, Object> columMap;
    private final ExcelResult<T> excelResult = new DefaultExcelResult();
    private final Boolean isValidate;
    private Map<Integer, String> headMap;

    public DefaultExcelListener(boolean isValidate, Map<String, Object> columMap) {
        this.isValidate = isValidate;
        this.columMap = columMap;
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.headMap = headMap;
        Set<String> headList = this.columMap.keySet();
        for (String value : headMap.values()) {
            if (headList.contains(value)) continue;
            throw new ExcelCommonException("\u8868\u5934\u6570\u636e\u65e0\u6cd5\u5339\u914d");
        }
        this.LOGGER.info("\u89e3\u6790\u5230\u4e00\u6761\u8868\u5934\u6570\u636e: {}", headMap);
    }

    public void onException(Exception exception, AnalysisContext context) {
        String errMsg = null;
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            Integer rowIndex = excelDataConvertException.getRowIndex();
            Integer columnIndex = excelDataConvertException.getColumnIndex();
            errMsg = StrUtil.format((CharSequence)"\u7b2c{}\u884c-\u7b2c{}\u5217-\u8868\u5934{}: \u89e3\u6790\u5f02\u5e38<br/>", (Object[])new Object[]{rowIndex + 1, columnIndex + 1, this.headMap.get(columnIndex)});
        }
        if (exception instanceof ExcelCommonException) {
            ExcelCommonException excelCommonException = (ExcelCommonException)exception;
            errMsg = excelCommonException.getMessage();
        }
        this.excelResult.getErrorList().add(errMsg);
        throw new ExcelAnalysisException(errMsg);
    }

    public void invoke(T data, AnalysisContext context) {
        Map map = (Map)data;
        if (this.isValidate.booleanValue() && map.size() > this.columMap.size()) {
            this.excelResult.getErrorList().add("\u8868\u683c\u5185\u5bb9\u6570\u636e\u957f\u5ea6\u8d85\u51fa\u8868\u5934\u957f\u5ea6!");
            throw new ExcelCommonException("\u8868\u683c\u5185\u5bb9\u6570\u636e\u957f\u5ea6\u8d85\u51fa\u8868\u5934\u957f\u5ea6!");
        }
        HashMap dataMap = new HashMap(map.size());
        map.forEach((k, v) -> dataMap.put(this.columMap.get(this.headMap.get(k)).toString(), v));
        this.excelResult.getList().add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.LOGGER.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    @Override
    public ExcelResult<T> getExcelResult() {
        return this.excelResult;
    }
}

