package com.af.v4.system.common.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;

/**
 * Character 转换类
 */

public class CharacterConverter implements Converter<Character> {

    @Override
    public Class<?> supportJavaTypeKey() {
        return Character.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Character convertToJavaData(ReadConverterContext<?> context) {
        String cellValue = context.getReadCellData().getStringValue();
        return cellValue.length() == 1
                ? cellValue.charAt(0)
                : '?';
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Character> context) {
        return new WriteCellData<>(context.getValue() != null ? context.getValue().toString() : "");
    }
}
