/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.excel.convert;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ExcelBigDecimalConvert
implements Converter<BigDecimal> {
    private static final int DECIMAL_SCALE = 4;
    private static final RoundingMode ROUNDING_MODE = RoundingMode.DOWN;

    public Class<BigDecimal> supportJavaTypeKey() {
        return BigDecimal.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.NUMBER;
    }

    public BigDecimal convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String stringValue = cellData.getStringValue();
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue).setScale(4, ROUNDING_MODE);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public WriteCellData<Object> convertToExcelData(BigDecimal value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (ObjectUtil.isNotNull((Object)value)) {
            BigDecimal scaledValue = value.setScale(4, ROUNDING_MODE);
            WriteCellData cellData = new WriteCellData(scaledValue);
            cellData.setType(CellDataTypeEnum.NUMBER);
            return cellData;
        }
        WriteCellData cellData = new WriteCellData(BigDecimal.ZERO);
        cellData.setType(CellDataTypeEnum.NUMBER);
        return cellData;
    }
}

