/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.excel.core;

import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.context.RowWriteHandlerContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExportStaffProgressWriteHandler
implements RowWriteHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportStaffProgressWriteHandler.class);
    private final ILogicServiceProxy logicService;
    private double row = 50.0;
    private int totalRows = 0;
    private int currentRow = 0;
    private String userId = "";
    private String taskName = "";

    public ExportStaffProgressWriteHandler(ILogicServiceProxy logicService) {
        this.logicService = logicService;
    }

    public void init(int totalRows, String taskName, String userId) {
        this.totalRows = totalRows;
        this.userId = userId;
        this.taskName = taskName;
    }

    public void afterRowCreate(RowWriteHandlerContext context) {
        Integer relativeRowIndex = context.getRelativeRowIndex();
        Boolean isHead = context.getHead();
        if (relativeRowIndex != null && !isHead.booleanValue()) {
            int current = ++this.currentRow;
            double progress = (double)current / (double)this.totalRows;
            progress = 50.0 + progress * 50.0;
            if ((progress = Math.ceil(progress * 100.0) / 100.0) > this.row) {
                JSONObject progressJson = new JSONObject().put("taskName", (Object)this.taskName).put("progress", progress);
                JSONObject message = new JSONObject().put("messageType", (Object)"task").put("progress", (Object)progressJson);
                JSONArray userList = new JSONArray().put((Object)this.userId);
                JSONObject param = new JSONObject().put("userList", (Object)userList).put("event", (Object)message.toString());
                this.logicService.remoteRun("af-system", "sendMessage", String.valueOf(param));
                this.row += 5.0;
            }
        }
    }
}

