package com.af.v4.system.common.excel.core;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.FillPatternType;

import java.util.List;

public class customHeaderStyleHandler extends HorizontalCellStyleStrategy {



    private final List<String> customHeader;

    public customHeaderStyleHandler(WriteCellStyle headWriteCellStyle, WriteCellStyle contentWriteCellStyleList, List<String> customHeader) {
        super(headWriteCellStyle, contentWriteCellStyleList);
        this.customHeader = customHeader;
    }

    @Override
    protected void setHeadCellStyle(CellWriteHandlerContext context) {

        WriteCellStyle headWriteCellStyle = getHeadWriteCellStyle();

        // 设置描述列表样式
        if (context.getRowIndex() < customHeader.size()) {
            // 背景颜色
            headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
            // 边框不展示
            headWriteCellStyle.setBorderRight(BorderStyle.NONE);
            headWriteCellStyle.setBorderLeft(BorderStyle.NONE);
            headWriteCellStyle.setBorderBottom(BorderStyle.NONE);
            headWriteCellStyle.setBorderTop(BorderStyle.NONE);
            // 字体大小
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints((short) 10);
            headWriteCellStyle.setWriteFont(headWriteFont);
            // 描述列表向左
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else {
            // 设置正常表头样式
            // 背景颜色
            headWriteCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            headWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            // 字体大小
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints((short) 12);
            headWriteCellStyle.setWriteFont(headWriteFont);
            // 表头居中
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        }

        if (stopProcessing(context)) {
            return;
        }
        WriteCellData<?> cellData = context.getFirstCellData();
        WriteCellStyle.merge(headWriteCellStyle, cellData.getOrCreateStyle());
    }
}
