/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.excel.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.IdUtil;
import com.af.v4.system.common.excel.constant.ExcelConstant;
import com.af.v4.system.common.excel.convert.BaseDateConverter;
import com.af.v4.system.common.excel.convert.CustomStringStringConverter;
import com.af.v4.system.common.excel.convert.ExcelBigNumberConvert;
import com.af.v4.system.common.excel.core.CellColorSheetWriteHandler;
import com.af.v4.system.common.excel.core.DefaultExcelListener;
import com.af.v4.system.common.excel.core.ExcelListener;
import com.af.v4.system.common.excel.core.ExcelResult;
import com.af.v4.system.common.excel.template.ExcelTemplate_Grey;
import com.af.v4.system.common.excel.utils.FileUtil;
import com.af.v4.system.common.resource.config.ResourceConfig;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.row.SimpleRowHeightStyleStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class ExcelService {
    private static int pageMaxSize;
    private final ResourceConfig resourceConfig;

    public ExcelService(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    private static String getExcelType(int dataSize, int headSize) {
        String type;
        if (dataSize < 65530 && headSize < 256) {
            type = "XLS";
            pageMaxSize = 65530;
        } else {
            type = "XLSX";
            pageMaxSize = 1048570;
        }
        return type;
    }

    private static void branchSheet(String sheetName, ExcelWriter writer, List<List<String>> head, List<List<Object>> writeData, List<Object> fillData) {
        int start = 0;
        int dataSize = writeData == null ? fillData.size() : writeData.size();
        int sheetCount = dataSize % pageMaxSize == 0 ? dataSize / pageMaxSize : dataSize / pageMaxSize + 1;
        try {
            for (int pageNo = 0; pageNo < sheetCount; ++pageNo) {
                int end = (pageNo + 1) * pageMaxSize;
                if (end > dataSize) {
                    end = dataSize;
                }
                if (head != null) {
                    writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)pageNo, (String)(sheetName + pageNo)).head(head)).build();
                    if (writeData != null) {
                        writer.write(writeData.subList(start, end), writeSheet);
                    }
                } else {
                    writeSheet = EasyExcel.writerSheet((Integer)pageNo, (String)(sheetName + pageNo)).build();
                    writer.fill(fillData.subList(start, end), writeSheet);
                }
                start = end;
            }
        }
        catch (Exception e) {
            throw new ExcelGenerateException("\u5206\u9875\u5bfc\u51fa\u9519\u8bef\uff01\u5982\u662f\u6a21\u677f\u586b\u5145\u5bfc\u51fa\u8bf7\u786e\u5b9a\u662f\u5426\u6839\u636e\u6587\u4ef6\u9650\u5236\u5927\u5c0f\u63d0\u524d\u8bbe\u7f6e\u6a21\u677f\u9875\u6570\uff01");
        }
    }

    private static void resetResponse(String sheetName, String type, HttpServletResponse response) {
        String filename = ExcelService.encodingFilename(sheetName, type);
        FileUtil.setAttachmentResponseHeader(response, filename);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
    }

    private static String encodingFilename(String filename, String type) {
        if (type.equals("XLSX")) {
            return filename + "_" + IdUtil.fastSimpleUUID() + ".xlsx";
        }
        if (type.equals("XLS")) {
            return filename + "_" + IdUtil.fastSimpleUUID() + ".xls";
        }
        return filename + "_" + IdUtil.fastSimpleUUID() + ".cvs";
    }

    public static <T> List<T> importExcel(InputStream is, JSONArray headList) {
        return ((ExcelReaderBuilder)EasyExcel.read((InputStream)is).head(ExcelService.assembleHead(headList))).autoCloseStream(Boolean.valueOf(false)).sheet().doReadSync();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Map<String, Object> headMap, boolean isValidate) {
        DefaultExcelListener listener = new DefaultExcelListener(isValidate, headMap);
        ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, listener).sheet().registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).registerConverter((Converter)new BaseDateConverter.LocalDateConverter())).registerConverter((Converter)new BaseDateConverter.LocalTimeConverter())).doRead();
        return listener.getExcelResult();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, ExcelListener<T> listener) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, listener).sheet().registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).doRead();
        return listener.getExcelResult();
    }

    private static ExcelWriterBuilder write(String type, OutputStream os, ExcelConstant constants, boolean hasStyle, List<Object> style, boolean hasAppoint, List<Object> appointCell) {
        ExcelWriterBuilder builder = (ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).autoCloseStream(Boolean.valueOf(false)).registerConverter((Converter)new ExcelBigNumberConvert())).registerConverter((Converter)new CustomStringStringConverter())).registerConverter((Converter)new BaseDateConverter.LocalDateTimeConverter())).excelType(ExcelTypeEnum.valueOf((String)type)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)new SimpleRowHeightStyleStrategy(Short.valueOf((short)20), Short.valueOf((short)20)));
        if (hasStyle) {
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = ExcelService.exportStyle(style, constants);
            builder.registerWriteHandler((WriteHandler)horizontalCellStyleStrategy);
        }
        if (hasAppoint) {
            HashMap map = (HashMap)appointCell.get(0);
            CellColorSheetWriteHandler writeHandler = new CellColorSheetWriteHandler(map, IndexedColors.RED.index, IndexedColors.YELLOW.index);
            builder.registerWriteHandler((WriteHandler)writeHandler);
        }
        return builder;
    }

    private static HorizontalCellStyleStrategy exportStyle(List<Object> styleList, ExcelConstant constants) {
        try {
            if (styleList != null) {
                Map styleMap = (Map)styleList.get(0);
                short head_font_size = Short.parseShort(styleMap.get("EXCEL_HEAD_FONT_SIZE").toString());
                String head_align = styleMap.get("EXCEL_HEAD_ALIGN").toString().toUpperCase();
                String head_font_color = styleMap.get("EXCEL_HEAD_FONT_COLOR").toString().toUpperCase();
                String head_full_color = styleMap.get("EXCEL_HEAD_FULL_COLOR").toString().toUpperCase();
                constants.EXCEL_HEAD_FONT_SIZE = head_font_size;
                constants.EXCEL_HEAD_ALIGN = HorizontalAlignment.valueOf((String)head_align);
                constants.EXCEL_HEAD_FONT_COLOR = IndexedColors.valueOf((String)head_font_color).getIndex();
                constants.EXCEL_HEAD_FULL_COLOR = IndexedColors.valueOf((String)head_full_color).getIndex();
            }
            return new HorizontalCellStyleStrategy(ExcelService.getWriteCellStyle(constants), new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException("Excel\u6837\u5f0f\u8bbe\u5b9a\u5f02\u5e38", e);
        }
    }

    private static WriteCellStyle getWriteCellStyle(ExcelConstant constants) {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headFont = new WriteFont();
        headFont.setColor(constants.EXCEL_HEAD_FONT_COLOR);
        headFont.setFontName(constants.EXCEL_HEAD_FONT_NAME);
        headFont.setFontHeightInPoints(constants.EXCEL_HEAD_FONT_SIZE);
        headWriteCellStyle.setWriteFont(headFont);
        headWriteCellStyle.setHorizontalAlignment(constants.EXCEL_HEAD_ALIGN);
        headWriteCellStyle.setFillForegroundColor(constants.EXCEL_HEAD_FULL_COLOR);
        headWriteCellStyle.setShrinkToFit(Boolean.valueOf(true));
        return headWriteCellStyle;
    }

    public static void exportExcel(List<Object> dataList, JSONArray headList, String sheetName, HttpServletResponse response) {
        ExcelService.exportExcel(dataList, headList, sheetName, null, true, new ExcelTemplate_Grey(), false, null, response);
    }

    public static void exportExcel(List<Object> dataList, JSONArray headList, String sheetName, List<Object> style, boolean hasStyle, ExcelConstant constant, boolean hasAppoint, List<Object> appointCell, HttpServletResponse response) {
        try {
            String type = ExcelService.getExcelType(dataList.size(), headList.length());
            ExcelService.resetResponse(sheetName, type, response);
            ServletOutputStream os = response.getOutputStream();
            List<List<String>> head = ExcelService.assembleHead(headList);
            List<List<Object>> data = ExcelService.assembleData(dataList);
            int dataSize = dataList.size();
            if (dataSize > pageMaxSize) {
                ExcelWriter writer = ExcelService.write(type, (OutputStream)os, constant, hasStyle, style, hasAppoint, appointCell).build();
                ExcelService.branchSheet(sheetName, writer, head, data, null);
                writer.finish();
            } else {
                ExcelWriterBuilder builder = ExcelService.write(type, (OutputStream)os, constant, hasStyle, style, hasAppoint, appointCell);
                ((ExcelWriterSheetBuilder)builder.sheet(sheetName).head(head)).doWrite(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38\uff01", e);
        }
    }

    public static void exportTemplate(List<Object> data, String fileName, String templatePath, HttpServletResponse response) {
        try {
            if (CollUtil.isEmpty(data)) {
                throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
            }
            String type = ExcelService.getExcelType(1, 1);
            ExcelService.resetResponse(fileName, type, response);
            ServletOutputStream os = response.getOutputStream();
            ClassPathResource templateResource = new ClassPathResource(templatePath);
            ExcelWriter writer = ExcelService.write(type, (OutputStream)os, null, false, null, false, null).withTemplate(templateResource.getStream()).build();
            int dataSize = data.size();
            if (dataSize > pageMaxSize) {
                ExcelService.branchSheet(fileName, writer, null, null, data);
            } else {
                WriteSheet writeSheet = EasyExcel.writerSheet().build();
                writer.fill(data, writeSheet);
            }
            writer.finish();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38", e);
        }
    }

    private static List<List<String>> assembleHead(JSONArray headList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        headList.forEach(str -> {
            ArrayList<String> heads = new ArrayList<String>();
            heads.add(str.toString());
            list.add(heads);
        });
        return list;
    }

    private static List<List<Object>> assembleData(List<Object> dataList) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>(dataList.size());
        dataList.forEach(item -> {
            Collection values = ((Map)item).values();
            ArrayList data = new ArrayList();
            values.forEach(v -> {
                if (JSONObject.NULL == v) {
                    v = "--";
                }
                data.add(v);
            });
            lists.add(data);
        });
        return lists;
    }

    private static List<List<Object>> assembleData(List<Object> dataList, List<String> fields) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>(dataList.size());
        dataList.forEach(item -> {
            ArrayList data = new ArrayList();
            fields.forEach(field -> {
                Object v = ((Map)item).get(field);
                if (JSONObject.NULL == v) {
                    v = "--";
                }
                data.add(v);
            });
            lists.add(data);
        });
        return lists;
    }

    private String exportExcelToServer(List<Object> dataList, JSONArray headList, List<String> fields, String sheetName, List<Object> style, boolean hasStyle, ExcelConstant constant, boolean hasAppoint, List<Object> appointCell) {
        try {
            String type = ExcelService.getExcelType(dataList.size(), headList.length());
            sheetName = ExcelService.encodingFilename(sheetName, type);
            String filePath = this.getFilePath();
            String fileName = this.getFileName(sheetName);
            List<List<String>> head = ExcelService.assembleHead(headList);
            List<List<Object>> data = fields == null ? ExcelService.assembleData(dataList) : ExcelService.assembleData(dataList, fields);
            int dataSize = dataList.size();
            try (FileOutputStream fos = new FileOutputStream(filePath + fileName);){
                if (dataSize > pageMaxSize) {
                    ExcelWriter writer = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell).build();
                    ExcelService.branchSheet(sheetName, writer, head, data, null);
                    writer.finish();
                } else {
                    ExcelWriterBuilder builder = ExcelService.write(type, fos, constant, hasStyle, style, hasAppoint, appointCell);
                    ((ExcelWriterSheetBuilder)builder.sheet(sheetName).head(head)).doWrite(data);
                }
            }
            return fileName;
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaExcel\u5f02\u5e38\uff01", e);
        }
    }

    public String exportExcelToServer(List<Object> dataList, JSONArray headList, String sheetName) {
        return this.exportExcelToServer(dataList, headList, null, sheetName, null, false, null, false, null);
    }

    public String exportExcelToServerByFieldList(List<Object> dataList, JSONArray fieldList, String sheetName) {
        JSONArray headList = new JSONArray();
        ArrayList<String> fields = new ArrayList<String>(fieldList.length());
        for (Object temp : fieldList) {
            fields.add(((String)temp).split(":")[0]);
            headList.put((Object)((String)temp).split(":")[1]);
        }
        return this.exportExcelToServer(dataList, headList, fields, sheetName, null, false, null, false, null);
    }

    private String getFilePath() {
        String filePath = this.resourceConfig.getFileRootPath() + "/excel/export/";
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return filePath;
    }

    private String getFileName(String name) {
        return name == null ? UUID.randomUUID() + ".xlsx" : name;
    }
}

