/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.common;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class ESConditionFactory {
    private final SearchRequest.Builder builder = new SearchRequest.Builder();
    private final Map<String, HighlightField> highlightFieldMap = new HashMap<String, HighlightField>();
    private final StringBuffer queryCondition = new StringBuffer();
    private StringBuffer shouldCondition = null;
    private StringBuffer mustCondition = null;
    private StringBuffer mustNotCondition = null;
    private int minimumShouldMatch = 0;
    private final String index;

    private StringBuffer getShouldCondition() {
        if (this.shouldCondition == null) {
            this.shouldCondition = new StringBuffer();
            this.shouldCondition.append("\"should\": [");
        } else {
            this.shouldCondition.append(",");
        }
        return this.shouldCondition;
    }

    private StringBuffer getMustCondition() {
        if (this.mustCondition == null) {
            this.mustCondition = new StringBuffer();
            this.mustCondition.append("\"must\": [");
        } else {
            this.mustCondition.append(",");
        }
        return this.mustCondition;
    }

    private StringBuffer getMustNotCondition() {
        if (this.mustNotCondition == null) {
            this.mustNotCondition = new StringBuffer();
            this.mustNotCondition.append("\"must_not\": [");
        } else {
            this.mustNotCondition.append(",");
        }
        return this.mustNotCondition;
    }

    private String getShouldResult() {
        if (this.shouldCondition == null) {
            return "";
        }
        this.shouldCondition.append("]");
        return this.shouldCondition.toString();
    }

    private String getMustResult() {
        if (this.mustCondition == null) {
            return "";
        }
        this.mustCondition.append("]");
        return this.mustCondition.toString();
    }

    private String getMustNotResult() {
        if (this.mustNotCondition == null) {
            return "";
        }
        this.mustNotCondition.append("]");
        return this.mustNotCondition.toString();
    }

    public ESConditionFactory(String index) {
        this.queryCondition.append("{");
        this.queryCondition.append("\"bool\": {");
        this.index = index;
    }

    public ESConditionFactory highlight(String preTag, String postTag, String[] highlightFields) {
        HighlightField.Builder builder = new HighlightField.Builder();
        builder.preTags(preTag, new String[0]);
        builder.postTags(postTag, new String[0]);
        HighlightField highlightOption = builder.build();
        for (String highlightField : highlightFields) {
            this.highlightFieldMap.put(highlightField, highlightOption);
        }
        return this;
    }

    public ESConditionFactory allField(String target) {
        StringBuffer shouldSB = this.getShouldCondition();
        shouldSB.append("{\"match\": {\"all_field_for_search\": \"");
        shouldSB.append(target);
        shouldSB.append("\"\n}}");
        return this;
    }

    public ESConditionFactory range(String fieldName, String rangeMode, String target) {
        StringBuffer mustSB = this.getMustCondition();
        switch (rangeMode) {
            case "gt": {
                mustSB.append("{\"range\": {\"").append(fieldName).append("\": {\"gt\": ").append(target).append("}}}");
                break;
            }
            case "gte": {
                mustSB.append("{\"range\": {\"").append(fieldName).append("\": {\"gte\": ").append(target).append("}}}");
                break;
            }
            case "lt": {
                mustSB.append("{\"range\": {\"").append(fieldName).append("\": {\"lt\": ").append(target).append("}}}");
                break;
            }
            case "lte": {
                mustSB.append("{\"range\": {\"").append(fieldName).append("\": {\"lte\": ").append(target).append("}}}");
            }
        }
        return this;
    }

    public ESConditionFactory between(String fieldName, String min, String minMode, String max, String maxMode) {
        StringBuffer mustSB = this.getMustCondition();
        String minModeStr = null;
        String maxModeStr = null;
        switch (minMode) {
            case "gt": {
                minModeStr = "gt";
                break;
            }
            case "gte": {
                minModeStr = "gte";
                break;
            }
            case "lt": {
                minModeStr = "lt";
                break;
            }
            case "lte": {
                minModeStr = "lte";
            }
        }
        switch (maxMode) {
            case "gt": {
                maxModeStr = "gt";
                break;
            }
            case "gte": {
                maxModeStr = "gte";
                break;
            }
            case "lt": {
                maxModeStr = "lt";
                break;
            }
            case "lte": {
                maxModeStr = "lte";
            }
        }
        mustSB.append("{\"range\": {\"");
        mustSB.append(fieldName);
        mustSB.append("\": {\"");
        mustSB.append(minModeStr);
        mustSB.append("\": ");
        mustSB.append(min);
        mustSB.append(",\"");
        mustSB.append(maxModeStr);
        mustSB.append("\": ");
        mustSB.append(max);
        mustSB.append("}}}");
        return this;
    }

    public ESConditionFactory should(String fieldName, String target) {
        StringBuffer shouldSB = this.getShouldCondition();
        shouldSB.append("{\"match\": {\"");
        shouldSB.append(fieldName);
        shouldSB.append("\": \"");
        shouldSB.append(target);
        shouldSB.append("\"}}");
        return this;
    }

    public ESConditionFactory shouldWithoutSplit(String fieldName, String target) {
        StringBuffer shouldSB = this.getShouldCondition();
        shouldSB.append("{\"term\": {\"");
        shouldSB.append(fieldName);
        shouldSB.append("\": \"");
        shouldSB.append(target);
        shouldSB.append("\"}}");
        return this;
    }

    public ESConditionFactory must(String fieldName, String target) {
        StringBuffer mustSB = this.getMustCondition();
        mustSB.append("{\"term\": {\"");
        mustSB.append(fieldName);
        mustSB.append("\": \"");
        mustSB.append(target);
        mustSB.append("\"}}");
        return this;
    }

    public ESConditionFactory mustNot(String fieldName, String target) {
        StringBuffer notSB = this.getMustNotCondition();
        notSB.append("{\"term\": {\"");
        notSB.append(fieldName);
        notSB.append("\": \"");
        notSB.append(target);
        notSB.append("\"}}");
        return this;
    }

    public ESConditionFactory findAll() {
        StringBuffer shouldSB = this.getShouldCondition();
        shouldSB.append("{\"match_all\": {}}");
        return this;
    }

    public ESConditionFactory order(String fieldName, SortOrder order) {
        this.builder.sort(s0 -> s0.field(f1 -> f1.field(fieldName).order(SortOrder.Desc)));
        return this;
    }

    public ESConditionFactory limit(int from, int size) {
        this.builder.from(Integer.valueOf(from));
        this.builder.size(Integer.valueOf(size));
        return this;
    }

    public ESConditionFactory minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public SearchRequest result() {
        String shouldResult = this.getShouldResult();
        String mustResult = this.getMustResult();
        String mustNotResult = this.getMustNotResult();
        boolean hasShould = false;
        if (shouldResult.length() > 0) {
            hasShould = true;
            this.queryCondition.append(shouldResult);
        }
        boolean hasMust = false;
        if (mustResult.length() > 0) {
            hasMust = true;
            if (hasShould) {
                this.queryCondition.append(",");
                this.queryCondition.append(mustResult);
            } else {
                this.queryCondition.append(mustResult);
            }
        }
        if (mustNotResult.length() > 0) {
            if (hasShould || hasMust) {
                this.queryCondition.append(",");
                this.queryCondition.append(mustNotResult);
            } else {
                this.queryCondition.append(mustNotResult);
            }
        }
        if (this.minimumShouldMatch > 0) {
            this.queryCondition.append(",");
            this.queryCondition.append("\"minimum_should_match\": ");
            this.queryCondition.append(this.minimumShouldMatch);
        }
        this.queryCondition.append("}");
        this.queryCondition.append("}");
        this.builder.index(this.index, new String[0]);
        this.builder.highlight(h -> h.fields(this.highlightFieldMap));
        String encodedJSON = Base64.getEncoder().encodeToString(this.queryCondition.toString().getBytes());
        this.builder.query(b0 -> b0.wrapper(b1 -> b1.query(encodedJSON)));
        return this.builder.build();
    }
}

