/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.common;

import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.elasticsearch.common.constance.AFLogstashTable;
import com.af.v4.system.common.elasticsearch.config.AFLogstashGlobalConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AFLogstashGenerator {
    private final AFLogstashGlobalConfig globalConfig;
    @Value(value="${logstash.outputFolder}")
    private String outputFolder;

    public AFLogstashGenerator(AFLogstashGlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void saveTableConf(List<AFLogstashTable> tableList) {
        for (AFLogstashTable table : tableList) {
            List<String> fieldNames = table.getAllFieldName();
            String outputPath = this.outputFolder + "\\" + table.getTableName() + ".conf";
            File file = new File(outputPath);
            if (!file.exists()) {
                try {
                    boolean bl = file.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String content = this.getConfContent(fieldNames, table);
            try (FileWriter fileWritter = new FileWriter(file, false);){
                fileWritter.write(content);
                fileWritter.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getConfContent(List<String> fieldNames, AFLogstashTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("input {");
        sb.append("\n");
        sb.append("\tjdbc {");
        sb.append("\n");
        sb.append("\t\tjdbc_driver_library => \"").append(this.globalConfig.getJDBCDriverPath()).append("\"");
        sb.append("\n");
        sb.append("\t\tjdbc_driver_class => \"").append(this.globalConfig.getJDBCDriverClassName()).append("\"");
        sb.append("\n");
        sb.append("\t\tjdbc_connection_string => \"").append(this.globalConfig.getDBurl()).append("\"");
        sb.append("\n");
        sb.append("\t\tjdbc_user => \"").append(this.globalConfig.getDBUsername()).append("\"");
        sb.append("\n");
        sb.append("\t\tjdbc_password => \"").append(this.globalConfig.getDBPassword()).append("\"");
        sb.append("\n");
        sb.append("\t\tschedule => \"").append(table.getSchedule()).append("\"");
        sb.append("\n");
        sb.append("\t\tstatement => \"SELECT * FROM ").append(table.getTableName()).append("\"");
        sb.append("\n");
        sb.append("\t\tuse_column_value => true");
        sb.append("\n");
        sb.append("\t\ttracking_column_type => \"").append(table.getUniqueFiledType()).append("\"");
        sb.append("\n");
        sb.append("\t\ttracking_column => \"").append(table.getUniqueFiled()).append("\"");
        sb.append("\n");
        sb.append("\t\tlast_run_metadata_path => \"syncpoint_table\"");
        sb.append("\n");
        sb.append("\t}");
        sb.append("\n");
        sb.append("}");
        sb.append("\n");
        sb.append("\n");
        sb.append("filter {");
        sb.append("\n");
        sb.append("\tmutate {");
        sb.append("\n");
        sb.append("\t\tadd_field => {\"").append(this.globalConfig.getAllFieldDefineName()).append("\" => \"");
        for (String name : fieldNames) {
            sb.append("%{").append(name).append("} ");
        }
        sb.append("\"}");
        sb.append("\n");
        sb.append("\t}");
        sb.append("\n");
        sb.append("\tmutate {");
        sb.append("\n");
        sb.append("\t\tadd_field => {\"tableName\" => \"").append(table.getTableName()).append("\"}");
        sb.append("\n");
        sb.append("\t}");
        sb.append("\n");
        sb.append("}");
        sb.append("\n");
        sb.append("\n");
        sb.append("output {");
        sb.append("\n");
        sb.append("\telasticsearch {");
        sb.append("\n");
        sb.append("\t\thosts => [\"").append(this.globalConfig.getESHost()).append("\"]");
        sb.append("\n");
        sb.append("\t\tindex => [\"").append(this.globalConfig.getESTargetIndex()).append("\"]");
        sb.append("\n");
        sb.append("\t\tdocument_id => \"%{").append(table.getIdField()).append("}\"");
        sb.append("\n");
        sb.append("\t}");
        sb.append("\tstdout {");
        sb.append("\n");
        sb.append("\t\tcodec => json_lines");
        sb.append("\n");
        sb.append("\t}");
        sb.append("\n");
        sb.append("}");
        return sb.toString();
    }

    public List<String> getAllFieldName(AFLogstashTable table) {
        DbType dbType = this.globalConfig.getDBType();
        Connection connect = this.getConnect();
        String sql = "";
        String tableName = table.getTableName();
        if (dbType == DbType.sqlserver) {
            sql = "select COLUMN_NAME from information_schema.COLUMNS where TABLE_NAME = ?";
        } else if (dbType == DbType.oracle) {
            sql = "select column_name  from user_tab_columns  where table_name= ?";
            tableName = tableName.toUpperCase();
        }
        ArrayList<String> colName = new ArrayList<String>();
        try {
            PreparedStatement preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, tableName);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String name = resultSet.getString(1);
                colName.add(name);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            connect.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colName;
    }

    public Connection getConnect() {
        Connection con;
        String url = this.globalConfig.getDBurl();
        String driver = this.globalConfig.getJDBCDriverClassName();
        String user = this.globalConfig.getDBUsername();
        String password = this.globalConfig.getDBPassword();
        try {
            Class.forName(driver);
            con = DriverManager.getConnection(url, user, password);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        return con;
    }
}

