/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.common;

import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ESConditionFactory {
    private final SearchSourceBuilder builder = new SearchSourceBuilder();
    private BoolQueryBuilder boolBuilder;
    private HighlightBuilder highlightBuilder;
    private boolean useShould = false;

    private void boolBuilderInit() {
        if (Optional.ofNullable(this.boolBuilder).isEmpty()) {
            this.boolBuilder = new BoolQueryBuilder();
        }
    }

    private void highlightInit() {
        if (Optional.ofNullable(this.highlightBuilder).isEmpty()) {
            this.highlightBuilder = new HighlightBuilder();
        }
    }

    public ESConditionFactory highlight(String preTag, String postTag, String[] highlightFields) {
        this.highlightInit();
        this.highlightBuilder.preTags(new String[]{preTag});
        this.highlightBuilder.postTags(new String[]{postTag});
        for (String highlightField : highlightFields) {
            this.highlightBuilder.field(highlightField);
        }
        return this;
    }

    public ESConditionFactory allField(String target) {
        this.builder.query((QueryBuilder)QueryBuilders.matchQuery((String)"all_field_for_search", (Object)target));
        return this;
    }

    public ESConditionFactory range(String fieldName, String rangeMode, String target) {
        this.boolBuilderInit();
        switch (rangeMode) {
            case "gt": {
                this.boolBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gt((Object)target));
                break;
            }
            case "gte": {
                this.boolBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gte((Object)target));
                break;
            }
            case "lt": {
                this.boolBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).lt((Object)target));
                break;
            }
            case "lte": {
                this.boolBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).lte((Object)target));
            }
        }
        return this;
    }

    public ESConditionFactory should(String fieldName, String target) {
        this.boolBuilderInit();
        this.useShould = true;
        this.boolBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)target));
        return this;
    }

    public ESConditionFactory must(String fieldName, String target) {
        this.boolBuilderInit();
        this.boolBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)target));
        return this;
    }

    public ESConditionFactory mustNot(String fieldName, String target) {
        this.boolBuilderInit();
        this.boolBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (String)target));
        return this;
    }

    public ESConditionFactory findAll() {
        this.builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        return this;
    }

    public ESConditionFactory order(String fieldName, SortOrder order) {
        this.builder.sort(fieldName, order);
        return this;
    }

    public ESConditionFactory limit(int from, int size) {
        this.builder.from(from);
        this.builder.size(size);
        return this;
    }

    public SearchSourceBuilder result() {
        if (this.useShould) {
            this.boolBuilder.minimumShouldMatch(1);
        }
        if (this.boolBuilder != null) {
            this.builder.query((QueryBuilder)this.boolBuilder);
        }
        if (this.highlightBuilder != null) {
            this.builder.highlighter(this.highlightBuilder);
        }
        return this.builder;
    }
}

