/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.elasticsearch.config.ElasticSearchConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AFLogstashGlobalConfig {
    private final ElasticSearchConfig esConfig;
    @Value(value="${logstash.allFieldDefineName}")
    private String allFieldDefineName;
    @Value(value="${logstash.ESTargetIndex}")
    private String ESTargetIndex;
    @Value(value="${logstash.JDBCDriverPath}")
    private String JDBCDriverPath;

    public AFLogstashGlobalConfig(ElasticSearchConfig esConfig) {
        this.esConfig = esConfig;
    }

    public String getJDBCDriverClassName() {
        return DynamicDataSource.getWrapper().getConfig().getDriverClassName();
    }

    public DbType getDBType() {
        return DynamicDataSource.getWrapper().getDbType();
    }

    public String getAllFieldDefineName() {
        return this.allFieldDefineName;
    }

    public String getESTargetIndex() {
        return this.ESTargetIndex;
    }

    public String getJDBCDriverPath() {
        return this.JDBCDriverPath;
    }

    public String getDBurl() {
        return DynamicDataSource.getWrapper().getConfig().getUrl();
    }

    public String getDBUsername() {
        return DynamicDataSource.getWrapper().getConfig().getUsername();
    }

    public String getDBPassword() {
        return DynamicDataSource.getWrapper().getConfig().getPassword();
    }

    public String getESHost() {
        String host = this.esConfig.getHost();
        String port = this.esConfig.getPort();
        return host + ":" + port;
    }
}

