/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.utils;

import com.af.v4.system.common.elasticsearch.config.ElasticSearchConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.xcontent.XContentType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AFElasticSearchDocUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AFElasticSearchDocUtils.class);
    private final ElasticSearchConfig config;

    public AFElasticSearchDocUtils(ElasticSearchConfig config) {
        this.config = config;
    }

    public void insert(String indexName, JSONArray data) {
        BulkResponse response;
        RestHighLevelClient client = this.config.getClient();
        BulkRequest bulkRequest = new BulkRequest();
        int sum = 0;
        for (int i = 0; i < data.length(); ++i) {
            ++sum;
            JSONObject item = data.getJSONObject(i);
            Set keySet = item.keySet();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : keySet) {
                map.put(key, item.get(key));
            }
            bulkRequest.add(new IndexRequest(indexName).source(map, XContentType.JSON));
        }
        try {
            response = client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u5b58\u50a8[{}]\u6761\u6570\u636e\u6210\u529f\uff01\u5171\u8017\u65f6\uff1a{}", (Object)sum, (Object)response.getTook());
    }

    public BulkResponse delete(String indexName, List<String> ids) {
        BulkResponse response;
        RestHighLevelClient client = this.config.getClient();
        BulkRequest bulkRequest = new BulkRequest();
        int sum = 0;
        for (String id : ids) {
            ++sum;
            bulkRequest.add(((DeleteRequest)new DeleteRequest().index(indexName)).id(id));
        }
        try {
            response = client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u5171\u5220\u9664\u6587\u6863[{}]\u4e2a\uff0c\u6267\u884c\u6210\u529f\uff01", (Object)sum);
        return response;
    }

    public List<List<Map<String, Object>>> search(String indexName, SearchSourceBuilder builder) {
        SearchResponse response;
        RestHighLevelClient client = this.config.getClient();
        SearchRequest request = new SearchRequest(new String[]{indexName});
        request.source(builder);
        try {
            response = client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SearchHits hits = response.getHits();
        ArrayList<List<Map<String, Object>>> hitResponse = new ArrayList<List<Map<String, Object>>>();
        for (SearchHit hit : hits) {
            ArrayList<Map> temp = new ArrayList<Map>();
            Map hitResult = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            Set keySet = highlightFields.keySet();
            HashMap<String, String> highlightItems = new HashMap<String, String>();
            for (String key : keySet) {
                String original = ((HighlightField)highlightFields.get(key)).toString();
                String modified = original.substring(original.lastIndexOf("[") + 1, original.length() - 2);
                highlightItems.put(key, modified);
            }
            HashMap<String, HashMap<String, String>> hitHighLightResult = new HashMap<String, HashMap<String, String>>();
            hitHighLightResult.put("highlight", highlightItems);
            temp.add(hitResult);
            temp.add(hitHighLightResult);
            hitResponse.add(temp);
        }
        return hitResponse;
    }
}

