package com.af.v4.system.common.elasticsearch.config;

import org.apache.http.HttpHost;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;

/**
 * ElasticSearch配置类
 * 从配置文件中读取连接信息，创建连接对象
 */
@Configuration
public class ElasticSearchConfig {
    @Value("${elasticsearch.host}")
    private String host;
    @Value("${elasticsearch.port}")
    private String port;

    private RestHighLevelClient client;

    @Bean
    public RestHighLevelClient client(){
        int portInt = Integer.parseInt(port);
        RestClientBuilder builder = RestClient.builder(new HttpHost(host, portInt, "http"));
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setKeepAliveStrategy((httpResponse, httpContext) -> Duration.ofMinutes(3).toMillis());
            httpClientBuilder.disableAuthCaching();
            return httpClientBuilder;
        });
        RestHighLevelClient localClient = new RestHighLevelClient(builder);
        this.client = localClient;
        return localClient;
    }

    public IndicesClient getIndices(){
        return this.getClient().indices();
    }

    public String getHost() {
        return host;
    }

    public String getPort() {
        return port;
    }

    public RestHighLevelClient getClient() {
        return client;
    }
}