/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.config;

import java.time.Duration;
import org.apache.http.HttpHost;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticSearchConfig {
    @Value(value="${elasticsearch.host}")
    private String host;
    @Value(value="${elasticsearch.port}")
    private String port;
    private RestHighLevelClient client;

    @Bean
    public RestHighLevelClient client() {
        RestHighLevelClient localClient;
        int portInt = Integer.parseInt(this.port);
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, portInt, "http")});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setKeepAliveStrategy((httpResponse, httpContext) -> Duration.ofMinutes(3L).toMillis());
            httpClientBuilder.disableAuthCaching();
            return httpClientBuilder;
        });
        this.client = localClient = new RestHighLevelClient(builder);
        return localClient;
    }

    public IndicesClient getIndices() {
        return this.getClient().indices();
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }
}

