/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.utils;

import com.af.v4.system.common.elasticsearch.config.ElasticSearchConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AFElasticSearchIndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AFElasticSearchIndexUtils.class);
    private final ElasticSearchConfig config;

    public AFElasticSearchIndexUtils(ElasticSearchConfig config) {
        this.config = config;
    }

    public CreateIndexResponse add(String indexName) {
        CreateIndexResponse response;
        boolean indexExist = this.isExist(indexName);
        if (indexExist) {
            LOGGER.warn("\u7d22\u5f15[" + indexName + "] \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa\uff01");
            return null;
        }
        IndicesClient indices = this.config.getIndices();
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        try {
            response = indices.create(createIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u521b\u5efaElasticSearch\u7d22\u5f15[{}] \u6210\u529f\uff01", (Object)indexName);
        return response;
    }

    public CreateIndexResponse addWithMapping(String indexName, String mapping) {
        CreateIndexResponse response;
        boolean indexExist = this.isExist(indexName);
        if (indexExist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa\uff01", (Object)indexName);
            return null;
        }
        IndicesClient indices = this.config.getIndices();
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.mapping(mapping, XContentType.JSON);
        try {
            response = indices.create(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u521b\u5efaElasticSearch\u7d22\u5f15[{}] \u6210\u529f\uff01", (Object)indexName);
        LOGGER.info("\u7d22\u5f15[{}] \u7684\u7ed3\u6784\u4e3a\uff1a{}", (Object)indexName, (Object)mapping);
        return response;
    }

    public boolean isExist(String indexName) {
        boolean exists;
        IndicesClient indices = this.config.getIndices();
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            exists = indices.exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return exists;
    }

    public boolean delete(String indexName) {
        AcknowledgedResponse delete;
        boolean exist = this.isExist(indexName);
        if (!exist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u4e0d\u5b58\u5728\uff01", (Object)indexName);
            return false;
        }
        IndicesClient indices = this.config.getIndices();
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        try {
            delete = indices.delete(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u5220\u9664\u7d22\u5f15[{}]\u6210\u529f\uff01", (Object)indexName);
        return delete.isAcknowledged();
    }

    public void showInfo(String indexName) {
        GetIndexResponse response;
        boolean exist = this.isExist(indexName);
        if (!exist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u4e0d\u5b58\u5728\uff01", (Object)indexName);
            return;
        }
        IndicesClient indices = this.config.getIndices();
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            response = indices.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Aliases:" + response.getAliases());
        System.out.println("Mapping:" + response.getMappings());
        System.out.println("Settings:" + response.getSettings());
    }

    public Map<String, Object> getMapping(String indexName) {
        GetIndexResponse response;
        boolean exist = this.isExist(indexName);
        if (!exist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u4e0d\u5b58\u5728\uff01", (Object)indexName);
            return null;
        }
        IndicesClient indices = this.config.getIndices();
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            response = indices.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map mappings = response.getMappings();
        Set keys = mappings.keySet();
        Iterator iterator = keys.iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            MappingMetadata mappingMetadata = (MappingMetadata)mappings.get(key);
            Map sourceAsMap = mappingMetadata.getSourceAsMap();
            return (Map)sourceAsMap.get("properties");
        }
        return null;
    }
}

