/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.MyDruidDataSource;
import com.af.v4.system.common.elasticsearch.config.ElasticSearchConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AFLogstashGlobalConfig {
    private final ElasticSearchConfig esConfig;
    @Value(value="${logstash.allFieldDefineName}")
    private String allFieldDefineName;
    @Value(value="${logstash.ESTargetIndex}")
    private String ESTargetIndex;
    @Value(value="${logstash.JDBCDriverPath}")
    private String JDBCDriverPath;

    public AFLogstashGlobalConfig(ElasticSearchConfig esConfig) {
        this.esConfig = esConfig;
    }

    public String getJDBCDriverClassName() {
        return DynamicDataSource.getDruidDataSource().getDriverClassName();
    }

    public String getDBType() {
        return DynamicDataSource.getDruidDataSource().getDbType();
    }

    public String getAllFieldDefineName() {
        return this.allFieldDefineName;
    }

    public String getESTargetIndex() {
        return this.ESTargetIndex;
    }

    public String getJDBCDriverPath() {
        return this.JDBCDriverPath;
    }

    public String getDBurl() {
        MyDruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getUrl();
    }

    public String getDBUsername() {
        MyDruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getUsername();
    }

    public String getDBPassword() {
        MyDruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getPassword();
    }

    public String getESHost() {
        String host = this.esConfig.getHost();
        String port = this.esConfig.getPort();
        return host + ":" + port;
    }
}

