package com.af.v4.system.common.elasticsearch.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 该类用于配置全局数据，数据源
 */
@Component
public class AFLogstashGlobalConfig {

    private final ElasticSearchConfig esConfig;
    @Value("${logstash.allFieldDefineName}")
    private String allFieldDefineName;
    @Value("${logstash.ESTargetIndex}")
    private String ESTargetIndex;
    @Value("${logstash.JDBCDriverPath}")
    private String JDBCDriverPath;

    public AFLogstashGlobalConfig(ElasticSearchConfig esConfig) {
        this.esConfig = esConfig;
    }

    public String getJDBCDriverClassName() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        String url = dataSource.getUrl();
        String[] split = url.split(":");
        String type = split[1];
        if (type.equals("sqlserver")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (type.equals("oracle")) {
            return "oracle.jdbc.driver.OracleDriver";
        } else {
            return "null";
        }
    }

    public String getDBType() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        String url = dataSource.getUrl();
        String[] split = url.split(":");
        return split[1];
    }

    public String getAllFieldDefineName() {
        return allFieldDefineName;
    }

    public String getESTargetIndex() {
        return ESTargetIndex;
    }

    public String getJDBCDriverPath() {
        return JDBCDriverPath;
    }

    public String getDBurl() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getUrl();
    }

    public String getDBUsername() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getUsername();
    }

    public String getDBPassword() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        return dataSource.getPassword();
    }

    public String getESHost() {
        String host = esConfig.getHost();
        String port = esConfig.getPort();
        return host + ":" + port;
    }
}
