package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 自定义数据源配置
 *
 * @author Mr.river
 */
public class AfDataSourceConfig {

    private final static Logger LOGGER = LoggerFactory.getLogger(AfDataSourceConfig.class);

    private String name;
    private String redirect;
    private String driverClassName;
    private DbType type;
    private String url;
    private String username;
    private String password;
    /**
     * hibernate 相关
     **/
    private String dialect;
    private List<String> cfgLocations;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRedirect() {
        return redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public String getDriverClassName() {
        return driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        LOGGER.warn("构建数据源时发现过时的数据源参数：[driverClassName]，请使用参数：[type]替代");
        DbType dbType = DbType.ofByDriverClassName(driverClassName);
        if (dbType == null) {
            throw new ServiceException("不支持的数据源驱动：" + driverClassName);
        }
        this.driverClassName = driverClassName;
        this.type = dbType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDialect() {
        return dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public List<String> getCfgLocations() {
        return cfgLocations;
    }

    public void setCfgLocations(List<String> cfgLocations) {
        this.cfgLocations = cfgLocations;
    }

    public DbType getType() {
        return type;
    }

    public void setType(String type) {
        DbType dbType = DbType.of(type.toLowerCase());
        if (dbType == null) {
            throw new ServiceException("不支持的数据源类型：" + type);
        }
        this.driverClassName = dbType.driverClassName;
        this.type = dbType;
    }
}
